/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.customers.transitions.configurations;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.rest.customers.transitions.configurations.WorkflowCustomerTransitionAssembler;
import com.atlassian.servicedesk.internal.rest.customers.transitions.configurations.WorkflowCustomerTransitionRequest;
import io.atlassian.fugue.Unit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="customertransition/workflow")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class WorkflowCustomerTransitionConfigurationResource {
    private final WorkflowCustomerTransitionAssembler customerTransitionConfigurationAssembler;
    private final FeatureManager featureManager;
    private final CommonErrors commonErrors;
    private final RestResponseHelper restResponseHelper;
    private final UserFactory userFactory;

    public WorkflowCustomerTransitionConfigurationResource(WorkflowCustomerTransitionAssembler customerTransitionConfigurationAssembler, FeatureManager featureManager, CommonErrors commonErrors, RestResponseHelper restResponseHelper, UserFactory userFactory) {
        this.customerTransitionConfigurationAssembler = customerTransitionConfigurationAssembler;
        this.featureManager = featureManager;
        this.commonErrors = commonErrors;
        this.restResponseHelper = restResponseHelper;
        this.userFactory = userFactory;
    }

    @GET
    @Path(value="/configurations")
    public Response getCustomerTransitionConfig(@QueryParam(value="workflowName") String workflowName) throws FieldException {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_PORTAL_TRANSITIONS_CONFIG)) {
            return this.restResponseHelper.anErrorToResponse(this.commonErrors.FEATURE_NOT_ENABLED());
        }
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).leftMap(err -> this.commonErrors.USER_NOT_EXIST_ERROR())).then(user -> this.customerTransitionConfigurationAssembler.getConfigurations((CheckedUser)user, workflowName)).yield((checkedUser, workflowCustomerTransitionConfigurationResponse) -> workflowCustomerTransitionConfigurationResponse);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @GET
    @Path(value="/transition/{transitionId}/configuration/options")
    public Response getResolutions(@QueryParam(value="workflowName") String workflowName, @PathParam(value="transitionId") int transitionId) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_PORTAL_TRANSITIONS_CONFIG)) {
            return this.restResponseHelper.anErrorToResponse(this.commonErrors.FEATURE_NOT_ENABLED());
        }
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).leftMap(err -> this.commonErrors.USER_NOT_EXIST_ERROR())).then(user -> this.customerTransitionConfigurationAssembler.getConfigurationOptions((CheckedUser)user, workflowName, transitionId)).yield((checkedUser, workflowCustomerTransitionOptionsResponse) -> workflowCustomerTransitionOptionsResponse);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @PUT
    @Path(value="/transition/{transitionId}/configuration/activate")
    public Response activateCustomerTransitionConfig(@QueryParam(value="workflowName") String workflowName, @PathParam(value="transitionId") int transitionId, WorkflowCustomerTransitionRequest configureCustomerTransitionRequest) throws FieldException {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_PORTAL_TRANSITIONS_CONFIG)) {
            return this.restResponseHelper.anErrorToResponse(this.commonErrors.FEATURE_NOT_ENABLED());
        }
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).leftMap(err -> this.commonErrors.USER_NOT_EXIST_ERROR())).then(user -> this.customerTransitionConfigurationAssembler.activateConfiguration((CheckedUser)user, workflowName, transitionId, configureCustomerTransitionRequest)).yield((checkedUser, workflowCustomerTransitionConfiguration) -> Unit.Unit());
        return this.restResponseHelper.anErrorEitherToNoContentResponse(result);
    }

    @PUT
    @Path(value="/transition/{transitionId}/configuration/deactivate")
    public Response deactivateCustomerTransitionConfig(@PathParam(value="transitionId") int transitionId, @QueryParam(value="workflowName") String workflowName) throws FieldException {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_PORTAL_TRANSITIONS_CONFIG)) {
            return this.restResponseHelper.anErrorToResponse(this.commonErrors.FEATURE_NOT_ENABLED());
        }
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).leftMap(err -> this.commonErrors.USER_NOT_EXIST_ERROR())).then(user -> this.customerTransitionConfigurationAssembler.deactivateConfiguration((CheckedUser)user, workflowName, transitionId)).yield((checkedUser, workflowCustomerTransitionConfiguration) -> Unit.Unit());
        return this.restResponseHelper.anErrorEitherToNoContentResponse(result);
    }
}

