/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.customers.transitions.configurations;

import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.util.WorkflowHelper;
import com.atlassian.servicedesk.internal.feature.customer.transitions.configurations.WorkflowCustomerTransitionConfiguration;
import com.atlassian.servicedesk.internal.feature.customer.transitions.configurations.WorkflowCustomerTransitionConfigurationService;
import com.atlassian.servicedesk.internal.rest.customers.transitions.configurations.WorkflowActionConfigurationResponse;
import com.atlassian.servicedesk.internal.rest.customers.transitions.configurations.WorkflowCustomerResolutionResponse;
import com.atlassian.servicedesk.internal.rest.customers.transitions.configurations.WorkflowCustomerTransitionConfigurationResponse;
import com.atlassian.servicedesk.internal.rest.customers.transitions.configurations.WorkflowCustomerTransitionOptionsResponse;
import com.atlassian.servicedesk.internal.rest.customers.transitions.configurations.WorkflowCustomerTransitionRequest;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowCustomerTransitionAssembler {
    private final WorkflowCustomerTransitionConfigurationService workflowCustomerTransitionConfigurationService;
    private final WorkflowHelper workflowHelper;
    private final ServiceDeskManager serviceDeskManager;
    private final ResolutionManager resolutionManager;

    @Autowired
    public WorkflowCustomerTransitionAssembler(WorkflowCustomerTransitionConfigurationService workflowCustomerTransitionConfigurationService, WorkflowHelper workflowHelper, ServiceDeskManager serviceDeskManager, ResolutionManager resolutionManager) {
        this.workflowCustomerTransitionConfigurationService = workflowCustomerTransitionConfigurationService;
        this.workflowHelper = workflowHelper;
        this.serviceDeskManager = serviceDeskManager;
        this.resolutionManager = resolutionManager;
    }

    public Either<AnError, WorkflowCustomerTransitionConfigurationResponse> getConfigurations(CheckedUser user, String workflowName) {
        return Steps.begin((Either)this.workflowHelper.getDraftWorkflow(user.forJIRA(), workflowName)).then(draftWorkflow -> this.workflowCustomerTransitionConfigurationService.getConfigurations(user, (JiraWorkflow)draftWorkflow)).yield(this::buildWorkflowConfigurationResponse);
    }

    public Either<AnError, WorkflowCustomerTransitionOptionsResponse> getConfigurationOptions(CheckedUser user, String workflowName, int transitionId) {
        return Steps.begin((Either)this.workflowHelper.getDraftWorkflow(user.forJIRA(), workflowName)).then(draftWorkflow -> this.workflowHelper.getActionByTransitionId(draftWorkflow, transitionId)).yield(this::buildWorkflowConfigurationOptionResponse);
    }

    public Either<AnError, WorkflowCustomerTransitionConfiguration> activateConfiguration(CheckedUser user, String workflowName, int transitionId, WorkflowCustomerTransitionRequest configureCustomerTransitionRequest) {
        return Steps.begin((Either)this.workflowHelper.getDraftWorkflow(user.forJIRA(), workflowName)).then(draftWorkflow -> this.workflowHelper.getActionByTransitionId(draftWorkflow, transitionId)).then((draftWorkflow, actionDescriptor) -> this.workflowCustomerTransitionConfigurationService.activateConfiguration(user, (JiraWorkflow)draftWorkflow, (ActionDescriptor)actionDescriptor, configureCustomerTransitionRequest)).yield((draftWorkflow, actionDescriptor, config) -> config);
    }

    public Either<AnError, WorkflowCustomerTransitionConfiguration> deactivateConfiguration(CheckedUser user, String workflowName, int transitionId) {
        return Steps.begin((Either)this.workflowHelper.getDraftWorkflow(user.forJIRA(), workflowName)).then(draftWorkflow -> this.workflowHelper.getActionByTransitionId(draftWorkflow, transitionId)).then((draftWorkflow, actionDescriptor) -> this.workflowCustomerTransitionConfigurationService.deactivateConfiguration(user, (JiraWorkflow)draftWorkflow, (ActionDescriptor)actionDescriptor)).yield((draftWorkflow, actionDescriptor, config) -> config);
    }

    private WorkflowCustomerTransitionConfigurationResponse buildWorkflowConfigurationResponse(JiraWorkflow workflow, List<WorkflowCustomerTransitionConfiguration> configurations) {
        List<WorkflowActionConfigurationResponse> workflowActionConfigurationResponses = configurations.stream().map(config -> new WorkflowActionConfigurationResponse(workflow.getName(), (WorkflowCustomerTransitionConfiguration)config)).collect(Collectors.toList());
        List projects = this.workflowHelper.getProjectsForWorkflow(workflow.getName());
        boolean isWorkflowAssociatedWithSD = projects.stream().anyMatch(project -> this.serviceDeskManager.getServiceDeskForProject(project).isRight());
        boolean isWorkflowAssociatedWithOther = projects.stream().anyMatch(project -> this.serviceDeskManager.getServiceDeskForProject(project).isLeft());
        return new WorkflowCustomerTransitionConfigurationResponse(workflowActionConfigurationResponses, isWorkflowAssociatedWithSD, isWorkflowAssociatedWithOther);
    }

    private WorkflowCustomerTransitionOptionsResponse buildWorkflowConfigurationOptionResponse(JiraWorkflow draftWorkflow, ActionDescriptor actionDescriptor) {
        boolean isInitial = draftWorkflow.isInitialAction(actionDescriptor);
        List<WorkflowCustomerResolutionResponse> resolutions = this.getResolutions();
        String postFunctionResolutionName = this.getPostFunctionResolutionName(draftWorkflow, actionDescriptor);
        return new WorkflowCustomerTransitionOptionsResponse(isInitial, resolutions, postFunctionResolutionName);
    }

    private List<WorkflowCustomerResolutionResponse> getResolutions() {
        return this.resolutionManager.getResolutions().stream().map(resolution -> new WorkflowCustomerResolutionResponse(resolution.getId(), resolution.getNameTranslation())).collect(Collectors.toList());
    }

    private String getPostFunctionResolutionName(JiraWorkflow draftWorkflow, ActionDescriptor actionDescriptor) {
        List postFunctionsWhichAffectTheResolution;
        boolean hasAPostFunctionWhichAffectsResolution = this.workflowHelper.hasAPostFunctionWhichAffectsResolution(Option.some((Object)draftWorkflow), actionDescriptor.getId());
        String postFunctionResolutionName = null;
        if (hasAPostFunctionWhichAffectsResolution && !(postFunctionsWhichAffectTheResolution = this.workflowHelper.getPostFunctionsWhichAffectResolution(Option.some((Object)draftWorkflow), actionDescriptor.getId())).isEmpty()) {
            String resolutionId = (String)((FunctionDescriptor)postFunctionsWhichAffectTheResolution.get(postFunctionsWhichAffectTheResolution.size() - 1)).getArgs().get("field.value");
            Resolution postFunctionResolution = this.resolutionManager.getResolution(resolutionId);
            postFunctionResolutionName = postFunctionResolution == null ? "" : postFunctionResolution.getNameTranslation();
        }
        return postFunctionResolutionName;
    }
}

