/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.customers.transitions;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.request.CustomerRequestQuery;
import com.atlassian.servicedesk.api.request.ServiceDeskCustomerRequestService;
import com.atlassian.servicedesk.api.request.transition.CustomerTransitionExecutionParameters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.customer.transitions.CustomerTransitionInternalService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.rest.customers.transitions.CustomerTransitionRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/customer/requests/transition")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CustomerTransitionResource {
    private final IssueService issueService;
    private final CustomerTransitionInternalService customerTransitionInternalService;
    private final FeatureManager featureManager;
    private final CommonErrors commonErrors;
    private final RestResponseHelper restResponseHelper;
    private final UserFactory userFactory;
    private final ServiceDeskCustomerRequestService serviceDeskCustomerRequestService;

    public CustomerTransitionResource(IssueService issueService, FeatureManager featureManager, CustomerTransitionInternalService customerTransitionInternalService, CommonErrors commonErrors, RestResponseHelper restResponseHelper, UserFactory userFactory, ServiceDeskCustomerRequestService serviceDeskCustomerRequestService) {
        this.issueService = issueService;
        this.featureManager = featureManager;
        this.customerTransitionInternalService = customerTransitionInternalService;
        this.commonErrors = commonErrors;
        this.restResponseHelper = restResponseHelper;
        this.userFactory = userFactory;
        this.serviceDeskCustomerRequestService = serviceDeskCustomerRequestService;
    }

    @PUT
    public Response transitionRequest(CustomerTransitionRequest request) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_PORTAL_TRANSITIONS)) {
            return this.restResponseHelper.anErrorToResponse(this.commonErrors.FEATURE_NOT_ENABLED());
        }
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.doTransition((CheckedUser)checkedUser, request)).yield((checkedUser, executeTransitionResult) -> executeTransitionResult);
        return (Response)result.fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), res -> (Response)res.fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).validationErrorsToResponse(arg_0), issue -> this.restResponseHelper.noContent()));
    }

    private io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationErrors, Issue>> doTransition(CheckedUser checkedUser, CustomerTransitionRequest customerTransitionRequest) {
        return Steps.begin((io.atlassian.fugue.Either)this.getRequest(checkedUser, customerTransitionRequest.issueKey).map(request -> this.customerTransitionInternalService.customerTransitionExecutionParameterBuilder().request(request).transitionId(Integer.valueOf(customerTransitionRequest.transitionId)).comment(customerTransitionRequest.comment).build())).then(params -> this.customerTransitionInternalService.executeCustomerTransition(checkedUser.forJIRA(), (CustomerTransitionExecutionParameters)params)).yield((params, executeTransitionResult) -> executeTransitionResult);
    }

    private io.atlassian.fugue.Either<AnError, CustomerRequest> getRequest(CheckedUser checkedUser, String issueKey) {
        IssueService.IssueResult issueResult = this.issueService.getIssue(checkedUser.forJIRA(), issueKey);
        if (!issueResult.isValid()) {
            return io.atlassian.fugue.Either.left((Object)this.commonErrors.ISSUE_NOT_FOUND());
        }
        CustomerRequestQuery query = this.serviceDeskCustomerRequestService.newQueryBuilder().issue(issueResult.getIssue().getId()).build();
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskCustomerRequestService.getCustomerRequests(checkedUser.forJIRA(), query).map(PagedResponse::findFirst))).yield(request -> (CustomerRequest)request.get());
    }
}

