/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.customers.share;

import com.atlassian.fugue.Either;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.request.RequestDetailsResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.request.avatar.SDAgentAvatarManager;
import com.atlassian.servicedesk.internal.feature.customer.search.CustomerSearchItemResult;
import com.atlassian.servicedesk.internal.feature.customer.search.OrganizationSearchItemResult;
import com.atlassian.servicedesk.internal.feature.customer.search.UserSearchItemResult;
import com.atlassian.servicedesk.internal.feature.customer.search.UsersAndOrganizationsSearchService;
import com.atlassian.servicedesk.internal.feature.jira.issue.IssueHelper;
import com.atlassian.servicedesk.internal.feature.shareparticipants.ShareParticipantsService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.rest.customers.share.request.RemoveOrganisationRequest;
import com.atlassian.servicedesk.internal.rest.customers.share.request.ShareParticipantsRequest;
import com.atlassian.servicedesk.internal.rest.customers.share.response.ShareSearchItemResponse;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="customer/participants")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ShareParticipantsResource {
    private final FeatureManager featureManager;
    private final RestResponseHelper restResponseHelper;
    private final CommonErrors commonErrors;
    private final UsersAndOrganizationsSearchService usersAndOrganizationsSearchService;
    private final SDAgentAvatarManager agentAvatarManager;
    private final IssueHelper issueHelper;
    private final UserFactory userFactory;
    private final RequestDetailsResponseProvider requestDetailsResponseProvider;
    private final ShareParticipantsService shareParticipantsService;
    private static final int DEFAULT_LIMIT = 20;

    public ShareParticipantsResource(FeatureManager featureManager, RestResponseHelper restResponseHelper, CommonErrors commonErrors, UsersAndOrganizationsSearchService usersAndOrganizationsSearchService, SDAgentAvatarManager agentAvatarManager, IssueHelper issueHelper, UserFactory userFactory, RequestDetailsResponseProvider requestDetailsResponseProvider, ShareParticipantsService shareParticipantsService) {
        this.featureManager = featureManager;
        this.restResponseHelper = restResponseHelper;
        this.commonErrors = commonErrors;
        this.usersAndOrganizationsSearchService = usersAndOrganizationsSearchService;
        this.agentAvatarManager = agentAvatarManager;
        this.issueHelper = issueHelper;
        this.userFactory = userFactory;
        this.requestDetailsResponseProvider = requestDetailsResponseProvider;
        this.shareParticipantsService = shareParticipantsService;
    }

    @GET
    @Path(value="{issueKey}/search")
    public Response searchForParticipants(@PathParam(value="issueKey") String issueKey, @QueryParam(value="q") String query) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return this.restResponseHelper.anErrorToResponse(this.commonErrors.FEATURE_NOT_ENABLED());
        }
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.issueHelper.getIssueByKey((CheckedUser)user, issueKey)).then((user, issue) -> this.search((CheckedUser)user, (Issue)issue, query)).yield((user, issue, searchResult) -> searchResult);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @PUT
    @Path(value="{issueKey}/share")
    public Response addParticipants(@PathParam(value="issueKey") String issueKey, @Nonnull ShareParticipantsRequest shareParticipantsRequest) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return this.restResponseHelper.anErrorToResponse(this.commonErrors.FEATURE_NOT_ENABLED());
        }
        Objects.requireNonNull(issueKey, "issueKey");
        Objects.requireNonNull(shareParticipantsRequest, "shareParticipantsRequest");
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.issueHelper.getIssueByKey((CheckedUser)user, issueKey)).then((user, issue) -> this.shareParticipantsService.shareParticipants((CheckedUser)user, (Issue)issue, shareParticipantsRequest)).then((user, issue, shareResult) -> this.requestDetailsResponseProvider.getRequestDetailsResponse((CheckedUser)user, (Issue)issue)).yield((user, issue, shareResult, requestDetailsResponse) -> requestDetailsResponse);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @PUT
    @Path(value="{issueKey}/removeOrganisation")
    public Response removeOrganisation(@PathParam(value="issueKey") String issueKey, RemoveOrganisationRequest removeOrganisationRequest) {
        Objects.requireNonNull(removeOrganisationRequest);
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return this.restResponseHelper.anErrorToResponse(this.commonErrors.FEATURE_NOT_ENABLED());
        }
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.issueHelper.getIssueByKey((CheckedUser)user, issueKey)).then((user, issue) -> this.shareParticipantsService.removeOrganizationFromIssue((CheckedUser)user, (Issue)issue, removeOrganisationRequest.getOrganisationId())).yield((user, issue, success) -> Unit.Unit());
        return this.restResponseHelper.anErrorEitherToNoContentResponse(result);
    }

    private io.atlassian.fugue.Either<AnError, List<ShareSearchItemResponse>> search(CheckedUser searcher, Issue issue, String query) {
        io.atlassian.fugue.Either<AnError, List<CustomerSearchItemResult>> searchResult = this.usersAndOrganizationsSearchService.searchForUsersAndOrganizations(searcher, issue, query, 20);
        if (searchResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)searchResult.left().get());
        }
        return io.atlassian.fugue.Either.right(this.buildShareSearchItemResponse((List)searchResult.right().get()));
    }

    private List<ShareSearchItemResponse> buildShareSearchItemResponse(List<CustomerSearchItemResult> searchResult) {
        ArrayList<ShareSearchItemResponse> searchItemResponses = new ArrayList<ShareSearchItemResponse>();
        searchResult.forEach(result -> {
            switch (result.getType()) {
                case USER: {
                    searchItemResponses.add(this.convertToResponse((UserSearchItemResult)result));
                    break;
                }
                case ORGANISATION: {
                    searchItemResponses.add(this.convertToResponse((OrganizationSearchItemResult)result));
                }
            }
        });
        return searchItemResponses;
    }

    private ShareSearchItemResponse convertToResponse(UserSearchItemResult userSearchItemResult) {
        CheckedUser user = userSearchItemResult.getValue();
        return new ShareSearchItemResponse(user, this.agentAvatarManager.processAvatarRequest(user.forJIRA(), Avatar.Size.SMALL));
    }

    private ShareSearchItemResponse convertToResponse(OrganizationSearchItemResult organizationSearchItemResult) {
        CustomerOrganization organisation = organizationSearchItemResult.getValue();
        return new ShareSearchItemResponse(organisation);
    }
}

