/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.customers.response;

import com.atlassian.servicedesk.internal.rest.customers.response.CustomerPageResponseItem;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class CustomerResultsResponse {
    private final String error;
    private final List<CustomerPageResponseItem> results;
    private final String query;
    private final long total;
    private final int pageNumber;
    private final int lastDeterminedPaged;
    private final boolean totalHasBeenDetermined;
    private final int resultsPerPage;
    private final int pageRange;

    public CustomerResultsResponse(List<CustomerPageResponseItem> results, String query, long total, int pageNumber, int lastDeterminedPaged, boolean totalHasBeenDetermined, int resultsPerPage, int pageRange) {
        this.results = ImmutableList.copyOf(results);
        this.query = query;
        this.total = total;
        this.totalHasBeenDetermined = totalHasBeenDetermined;
        this.lastDeterminedPaged = lastDeterminedPaged;
        this.pageNumber = pageNumber;
        this.resultsPerPage = resultsPerPage;
        this.pageRange = pageRange;
        this.error = null;
    }

    public CustomerResultsResponse(String error, String query, long total, int pageNumber, int lastDeterminedPaged, boolean totalHasBeenDetermined, int resultsPerPage, int pageRange) {
        this.error = error;
        this.query = query;
        this.total = total;
        this.totalHasBeenDetermined = totalHasBeenDetermined;
        this.lastDeterminedPaged = lastDeterminedPaged;
        this.pageNumber = pageNumber;
        this.resultsPerPage = resultsPerPage;
        this.pageRange = pageRange;
        this.results = null;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public boolean isTotalHasBeenDetermined() {
        return this.totalHasBeenDetermined;
    }

    public String getError() {
        return this.error;
    }

    public int getLastDeterminedPaged() {
        return this.lastDeterminedPaged;
    }

    public String getQuery() {
        return this.query;
    }

    public List<CustomerPageResponseItem> getResults() {
        return this.results;
    }

    public long getTotal() {
        return this.total;
    }

    public int getResultsPerPage() {
        return this.resultsPerPage;
    }

    public int getPageRange() {
        return this.pageRange;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("error", (Object)this.error).add("results", this.results).add("query", (Object)this.query).add("total", this.total).add("pageNumber", this.pageNumber).add("lastDeterminedPaged", this.lastDeterminedPaged).add("totalHasBeenDetermined", this.totalHasBeenDetermined).add("resultsPerPage", this.resultsPerPage).add("pageRange", this.pageRange).toString();
    }
}

