/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.customers;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.feature.customer.user.InternalCustomerService;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.CustomerInviteManager;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.FailedInviteResult;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.InviteCustomerResult;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.result.SuccessInviteResult;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.validation.CustomerInviteValidation;
import com.atlassian.servicedesk.internal.feature.customer.user.invite.validation.CustomerInviteValidationStatus;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationService;
import com.atlassian.servicedesk.internal.feature.organization.error.CustomerOrganizationError;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.rest.customers.request.CustomerInviteRequest;
import com.atlassian.servicedesk.internal.rest.customers.response.CustomerFailedInviteResponse;
import com.atlassian.servicedesk.internal.rest.customers.response.CustomerInviteResponse;
import com.atlassian.servicedesk.internal.rest.customers.response.CustomerSuccessInviteResponse;
import com.atlassian.servicedesk.internal.utils.CustomerUrlUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Pair;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="pages/people/customers/pagination/{projectKey}/invite")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class InviteCustomerResource {
    private final UserFactory userFactory;
    private final InternalServiceDeskService internalServiceDeskService;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final InternalCustomerService customerService;
    private final CustomerUrlUtil customerUrlUtil;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final RestResponseHelper restResponseHelper;
    private final FeatureManager featureManager;
    private final CustomerContextService customerContextService;
    private final CustomerOrganizationService customerOrganizationService;
    private final CommonErrors commonErrors;
    private final CustomerOrganizationError customerOrganizationError;

    @Autowired
    protected InviteCustomerResource(InternalCustomerService customerService, UserFactory userFactory, InternalServiceDeskService internalServiceDeskService, ServiceDeskProjectService serviceDeskProjectService, CustomerUrlUtil customerUrlUtil, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, RestResponseHelper restResponseHelper, FeatureManager featureManager, CustomerContextService customerContextService, CustomerOrganizationService customerOrganizationService, CommonErrors commonErrors, CustomerOrganizationError customerOrganizationError) {
        this.customerService = customerService;
        this.userFactory = userFactory;
        this.internalServiceDeskService = internalServiceDeskService;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.customerUrlUtil = customerUrlUtil;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.restResponseHelper = restResponseHelper;
        this.featureManager = featureManager;
        this.customerContextService = customerContextService;
        this.customerOrganizationService = customerOrganizationService;
        this.commonErrors = commonErrors;
        this.customerOrganizationError = customerOrganizationError;
    }

    @POST
    @Path(value="validate")
    public Response validateInviteCustomers(@PathParam(value="projectKey") String projectKey, CustomerInviteRequest customerInviteRequest) {
        return this.doValidateInviteCustomers(projectKey, customerInviteRequest);
    }

    @POST
    public Response inviteCustomers(@PathParam(value="projectKey") String projectKey, CustomerInviteRequest customerInviteRequest) {
        return this.doInviteCustomers(projectKey, customerInviteRequest);
    }

    @POST
    @Path(value="organisation")
    public Response inviteCustomersByName(@PathParam(value="projectKey") String projectKey, @QueryParam(value="name") String organizationName, CustomerInviteRequest customerInviteRequest) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return this.restResponseHelper.anErrorToResponse(this.commonErrors.FEATURE_NOT_ENABLED());
        }
        return this.doInviteCustomersByName(projectKey, organizationName, customerInviteRequest);
    }

    @PUT
    @Path(value="organisation")
    public Response inviteCustomersById(@PathParam(value="projectKey") String projectKey, @QueryParam(value="id") int organizationId, CustomerInviteRequest customerInviteRequest) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return this.restResponseHelper.anErrorToResponse(this.commonErrors.FEATURE_NOT_ENABLED());
        }
        return this.doInviteCustomersById(projectKey, organizationId, customerInviteRequest);
    }

    private io.atlassian.fugue.Either<AnError, CustomerInviteManager.CustomerInviteValidationResult> validateInviteCustomersRequest(String projectKey, CustomerInviteRequest customerInviteRequest) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.internalServiceDeskService.getServiceDeskForProject(user, project, false)).then((user, project, serviceDesk) -> this.customerService.validateInviteCustomers((CheckedUser)user, (ServiceDesk)serviceDesk, (Project)project, Sets.newHashSet((Iterable)((Iterable)customerInviteRequest.getEmails().getOrElse(Collections.emptyList()))))).yield((user, project, serviceDesk, inviteResult) -> inviteResult);
    }

    private Response doValidateInviteCustomers(String projectKey, CustomerInviteRequest customerInviteRequest) {
        io.atlassian.fugue.Either<AnError, CustomerInviteManager.CustomerInviteValidationResult> result = this.validateInviteCustomersRequest(projectKey, customerInviteRequest);
        return (Response)result.fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), this::validationSuccess);
    }

    private Response doInviteCustomers(String projectKey, CustomerInviteRequest customerInviteRequest) {
        io.atlassian.fugue.Either result = Steps.begin(this.validateInviteCustomersRequest(projectKey, customerInviteRequest)).then(this.customerService::inviteCustomers).yield((customerInviteValidationResult, inviteResult) -> inviteResult);
        return (Response)result.fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), this::inviteSuccess);
    }

    private Response doInviteCustomersByName(String projectKey, String organizationName, CustomerInviteRequest customerInviteRequest) {
        if (StringUtils.isBlank((String)organizationName)) {
            return this.restResponseHelper.anErrorToResponse(this.customerOrganizationError.ORGANIZATION_NAME_EMPTY());
        }
        io.atlassian.fugue.Either result = Steps.begin(this.validateInviteCustomersRequest(projectKey, customerInviteRequest)).then(customerInviteValidationResult -> this.customerService.inviteCustomersToOrganizationByName((CustomerInviteManager.CustomerInviteValidationResult)customerInviteValidationResult, organizationName)).yield((customerInviteValidationResult, inviteResult) -> inviteResult);
        return (Response)result.fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), this::inviteSuccess);
    }

    private Response doInviteCustomersById(String projectKey, int organizationId, CustomerInviteRequest customerInviteRequest) {
        io.atlassian.fugue.Either result = Steps.begin(this.validateInviteCustomersRequest(projectKey, customerInviteRequest)).then(customerInviteValidationResult -> this.customerOrganizationService.getOrganization(customerInviteValidationResult.getCheckedUser(), organizationId)).then(this.customerService::inviteCustomersToOrganization).yield((customerInviteValidationResult, customerOrganization, inviteResult) -> inviteResult);
        return (Response)result.fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), this::inviteSuccess);
    }

    private Response validationSuccess(CustomerInviteManager.CustomerInviteValidationResult customerInviteValidationResult) {
        boolean canAdministerJIRA = this.serviceDeskLicenseAndPermissionService.canAdministerJIRA((SDUser)customerInviteValidationResult.getCheckedUser());
        CustomerInviteResponse customerInviteResponse = InviteCustomerResource.transformInviteValidationResponse(this.customerContextService.isInCustomerContext(), canAdministerJIRA, this.customerUrlUtil.getJIRABaseUrl(false), customerInviteValidationResult);
        if (customerInviteResponse.hasFailure()) {
            return Response.status((int)HttpStatusCode.BAD_REQUEST).entity((Object)customerInviteResponse).build();
        }
        return this.restResponseHelper.ok((Object)customerInviteResponse);
    }

    private Response inviteSuccess(InviteCustomerResult inviteCustomerResult) {
        CustomerInviteResponse customerInviteResponse = InviteCustomerResource.transformInviteResponse(inviteCustomerResult);
        if (customerInviteResponse.hasFailure()) {
            return Response.status((int)HttpStatusCode.BAD_REQUEST).entity((Object)customerInviteResponse).build();
        }
        return this.restResponseHelper.ok((Object)customerInviteResponse);
    }

    @VisibleForTesting
    static CustomerInviteResponse transformInviteResponse(InviteCustomerResult inviteResult) {
        List<FailedInviteResult> failedInvites = inviteResult.getFailedInvites();
        List<SuccessInviteResult> successInvites = inviteResult.getSuccessInvites();
        List<CustomerFailedInviteResponse> failedResult = failedInvites.stream().map(failedInvite -> new CustomerFailedInviteResponse(failedInvite.getKey(), failedInvite.getEmailAddressOrUsername(), failedInvite.getDisplayName(), failedInvite.getMessage())).collect(Collectors.toList());
        List<CustomerSuccessInviteResponse> successResult = successInvites.stream().map(success -> new CustomerSuccessInviteResponse(success.getKey(), success.getEmailAddressOrUsername(), success.getDisplayName())).collect(Collectors.toList());
        return new CustomerInviteResponse(successResult, failedResult);
    }

    @VisibleForTesting
    static CustomerInviteResponse transformInviteValidationResponse(boolean isInCustomerPortalContext, boolean isJiraAdmin, String jiraBaseUrl, CustomerInviteManager.CustomerInviteValidationResult customerInviteValidationResult) {
        Pair partition = Iterables.partition(customerInviteValidationResult.getCustomerInviteValidations(), customerInviteValidation -> !customerInviteValidation.getCustomerInviteValidationStatus().isValid());
        List<CustomerFailedInviteResponse> failedResult = StreamSupport.stream(((Iterable)partition.left()).spliterator(), false).map(failed -> new CustomerFailedInviteResponse(CustomerInviteValidation.extractKey(failed), CustomerInviteValidation.extractUsernameOrEmailAddress(failed), CustomerInviteValidation.extractDisplayValue(failed), CustomerInviteValidationStatus.getErrorHtml(customerInviteValidationResult.getCheckedUser().i18NHelper(), isJiraAdmin, isInCustomerPortalContext, jiraBaseUrl, failed))).collect(Collectors.toList());
        List<CustomerSuccessInviteResponse> successResult = StreamSupport.stream(((Iterable)partition.right()).spliterator(), false).map(success -> new CustomerSuccessInviteResponse(CustomerInviteValidation.extractKey(success), CustomerInviteValidation.extractUsernameOrEmailAddress(success), CustomerInviteValidation.extractDisplayValue(success))).collect(Collectors.toList());
        return new CustomerInviteResponse(successResult, failedResult);
    }
}

