/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.customers;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.onboarding.OnBoardingPropertiesService;
import com.atlassian.servicedesk.internal.feature.customer.search.CustomerSearchItemResult;
import com.atlassian.servicedesk.internal.feature.customer.search.UserSearchItemResult;
import com.atlassian.servicedesk.internal.feature.customer.search.UsersAndOrganizationsSearchService;
import com.atlassian.servicedesk.internal.feature.customer.user.CustomerServiceValidator;
import com.atlassian.servicedesk.internal.feature.customer.user.InternalCustomerService;
import com.atlassian.servicedesk.internal.feature.organization.member.CustomerOrganizationMemberManager;
import com.atlassian.servicedesk.internal.feature.organization.setting.CustomerOrganizationSettingService;
import com.atlassian.servicedesk.internal.feature.organization.util.CustomerOrganizationUtil;
import com.atlassian.servicedesk.internal.feature.servicedesk.InternalServiceDeskAccessService;
import com.atlassian.servicedesk.internal.feature.usermanagement.AgentService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.notifications.ServiceDeskNotificationInternalSender;
import com.atlassian.servicedesk.internal.permission.restore.PermissionSchemeMisconfigurationService;
import com.atlassian.servicedesk.internal.rest.customers.response.CustomerPageResponse;
import com.atlassian.servicedesk.internal.rest.customers.response.CustomerResultsResponse;
import com.atlassian.servicedesk.internal.rest.util.UserAndOrgPaginationHelper;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.internal.util.paging.LazyPagedResponse;
import com.atlassian.servicedesk.internal.util.paging.LazyPagedResponseImpl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class CustomersPageDataProvider {
    private static final int ONE = 1;
    private static final int UNLIMITED_AGENT_LIMIT = -1;
    private final InternalCustomerService customerService;
    private final InternalServiceDeskService internalServiceDeskService;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final CustomerServiceValidator customerServiceValidator;
    private final OnBoardingPropertiesService onBoardingPropertiesService;
    private final PermissionSchemeMisconfigurationService permissionSchemeMisconfigurationService;
    private final UserManager userManager;
    private final ServiceDeskNotificationInternalSender serviceDeskNotificationInternalSender;
    private final FeatureManager featureManager;
    private final UsersAndOrganizationsSearchService usersAndOrganizationsSearchService;
    private final CustomerOrganizationMemberManager customerOrganizationMemberManager;
    private final AgentService agentService;
    private final UserAndOrgPaginationHelper userAndOrgPaginationHelper;
    private final InternalServiceDeskAccessService internalServiceDeskAccessService;
    private final CustomerOrganizationSettingService customerOrganizationSettingService;

    @Autowired
    public CustomersPageDataProvider(InternalCustomerService customerService, InternalServiceDeskService internalServiceDeskService, ServiceDeskPermissions serviceDeskPermissions, CustomerServiceValidator customerServiceValidator, OnBoardingPropertiesService onBoardingPropertiesService, PermissionSchemeMisconfigurationService permissionSchemeMisconfigurationService, UserManager userManager, ServiceDeskNotificationInternalSender serviceDeskNotificationInternalSender, FeatureManager featureManager, UsersAndOrganizationsSearchService usersAndOrganizationsSearchService, CustomerOrganizationMemberManager customerOrganizationMemberManager, AgentService agentService, InternalServiceDeskAccessService internalServiceDeskAccessService, UserAndOrgPaginationHelper userAndOrgPaginationHelper, CustomerOrganizationSettingService customerOrganizationSettingService) {
        this.customerService = customerService;
        this.internalServiceDeskService = internalServiceDeskService;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.customerServiceValidator = customerServiceValidator;
        this.onBoardingPropertiesService = onBoardingPropertiesService;
        this.permissionSchemeMisconfigurationService = permissionSchemeMisconfigurationService;
        this.userManager = userManager;
        this.serviceDeskNotificationInternalSender = serviceDeskNotificationInternalSender;
        this.featureManager = featureManager;
        this.usersAndOrganizationsSearchService = usersAndOrganizationsSearchService;
        this.customerOrganizationMemberManager = customerOrganizationMemberManager;
        this.agentService = agentService;
        this.internalServiceDeskAccessService = internalServiceDeskAccessService;
        this.userAndOrgPaginationHelper = userAndOrgPaginationHelper;
        this.customerOrganizationSettingService = customerOrganizationSettingService;
    }

    public Either<AnError, CustomerPageResponse> getData(CheckedUser user, Project project) {
        Either serviceDeskForProject = this.internalServiceDeskService.getServiceDeskForProject(user, project, false);
        if (this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS) && this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_LIST_PAGE_LAZY_SEARCH)) {
            return serviceDeskForProject.flatMap(serviceDesk -> this.doActuallyGetLazyData(user, project, (ServiceDesk)serviceDesk));
        }
        return serviceDeskForProject.flatMap(serviceDesk -> {
            int blockSize = this.userAndOrgPaginationHelper.getFetchBlockSize();
            int maxPages = this.userAndOrgPaginationHelper.getMaximumPagesToShow();
            return this.doActuallyGetData(user, project, (ServiceDesk)serviceDesk, blockSize, maxPages);
        });
    }

    public Either<AnError, CustomerResultsResponse> searchCustomers(CheckedUser user, Project project, String query, int pageNumber) {
        int blockSize = this.userAndOrgPaginationHelper.getFetchBlockSize();
        int maxPages = this.userAndOrgPaginationHelper.getMaximumPagesToShow();
        return this.internalServiceDeskService.getServiceDeskForProject(user, project, false).flatMap(serviceDesk -> this.doActuallySearchCustomers(user, project, (ServiceDesk)serviceDesk, query, pageNumber, blockSize, maxPages));
    }

    private Either<AnError, CustomerPageResponse> doActuallyGetLazyData(CheckedUser user, Project project, ServiceDesk serviceDesk) {
        return Either.right((Object)this.createBaseCustomerPageResponse(true, user, project, serviceDesk));
    }

    private Either<AnError, CustomerPageResponse> doActuallyGetData(CheckedUser user, Project project, ServiceDesk serviceDesk, int blockSize, int maxPages) {
        CustomerPageResponse customerPageResponse = this.createBaseCustomerPageResponse(false, user, project, serviceDesk);
        Option<CustomerResultsResponse> invalidRequest = this.userAndOrgPaginationHelper.checkPageNumberRequest(user, 1, "", project, blockSize, maxPages);
        if (invalidRequest.isDefined()) {
            customerPageResponse.setCustomerResults((CustomerResultsResponse)invalidRequest.get());
            return Either.right((Object)customerPageResponse);
        }
        LimitedPagedRequest pagedRequest = this.userAndOrgPaginationHelper.createSearchPageRequest(1, blockSize, maxPages);
        Either<AnError, LazyPagedResponse<CustomerSearchItemResult>> userLazyPagedResponse = this.performGetData(user, pagedRequest, serviceDesk, project);
        return userLazyPagedResponse.map(result -> {
            CustomerResultsResponse customerResultsResponse = this.userAndOrgPaginationHelper.createCustomerResultsResponse(user, "", 1, project, (LazyPagedResponse<CustomerSearchItemResult>)result, blockSize, maxPages, (Option<String>)Option.none(), false);
            customerPageResponse.setCustomerResults(customerResultsResponse);
            return customerPageResponse;
        });
    }

    private Either<AnError, CustomerResultsResponse> doActuallySearchCustomers(CheckedUser user, Project project, ServiceDesk serviceDesk, String query, int pageNumber, int blockSize, int maxPages) {
        boolean showUserOrg;
        Either<AnError, LazyPagedResponse<CustomerSearchItemResult>> lazyPagedResponseEither;
        Option<CustomerResultsResponse> invalidRequest = this.userAndOrgPaginationHelper.checkPageNumberRequest(user, pageNumber, query, project, blockSize, maxPages);
        if (invalidRequest.isDefined()) {
            return Either.right((Object)invalidRequest.get());
        }
        LimitedPagedRequest searchPageRequest = this.userAndOrgPaginationHelper.createSearchPageRequest(pageNumber, blockSize, maxPages);
        if (StringUtils.isBlank((String)query)) {
            lazyPagedResponseEither = this.performGetData(user, searchPageRequest, serviceDesk, project);
            showUserOrg = false;
        } else {
            lazyPagedResponseEither = this.performSearch(user, query, searchPageRequest, serviceDesk, project);
            showUserOrg = true;
        }
        return lazyPagedResponseEither.map(searchResult -> this.userAndOrgPaginationHelper.createCustomerResultsResponse(user, query, pageNumber, project, (LazyPagedResponse<CustomerSearchItemResult>)searchResult, blockSize, maxPages, (Option<String>)Option.none(), showUserOrg));
    }

    @VisibleForTesting
    Either<AnError, LazyPagedResponse<CustomerSearchItemResult>> performSearch(CheckedUser user, String nameOrEmailQuery, LimitedPagedRequest pagedRequest, ServiceDesk serviceDesk, Project project) {
        if (this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Steps.begin(this.getExcludedAgents(user, project)).then(excludedAgents -> this.usersAndOrganizationsSearchService.searchForUsersAndOrganizationWithExcludedResult(user, project, nameOrEmailQuery, (Set<String>)excludedAgents, pagedRequest)).yield((excludedAgents, pagedResponse) -> pagedResponse);
        }
        return this.customerService.searchCustomers(user, nameOrEmailQuery, pagedRequest, serviceDesk, project).map(this::transformToSearchItemResultPagedResponse);
    }

    @VisibleForTesting
    Either<AnError, LazyPagedResponse<CustomerSearchItemResult>> performGetData(CheckedUser user, LimitedPagedRequest pagedRequest, ServiceDesk serviceDesk, Project project) {
        if (this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Steps.begin(this.getExcludedAgentsAndMembersInOrganizations(user, project)).then(excludedUsers -> this.usersAndOrganizationsSearchService.getAllUserAndOrganizationWithExcludedResult(user, project, (Set<String>)excludedUsers, pagedRequest)).yield((excludedUsers, pagedResponse) -> pagedResponse);
        }
        return this.customerService.searchCustomers(user, "", pagedRequest, serviceDesk, project).map(this::transformToSearchItemResultPagedResponse);
    }

    private Either<AnError, Set<String>> getExcludedAgentsAndMembersInOrganizations(CheckedUser user, Project project) {
        return this.getExcludedAgents(user, project).map(agents -> {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.addAll((Iterable)agents);
            builder.addAll(this.customerOrganizationMemberManager.getUserKeysOfOrganizationMembers(project));
            return builder.build();
        });
    }

    private Either<AnError, Set<String>> getExcludedAgents(CheckedUser user, Project project) {
        return this.agentService.getAgentsByProject(user, project, -1).map(CustomerOrganizationUtil::transformToUserKeys);
    }

    @VisibleForTesting
    CustomerPageResponse createBaseCustomerPageResponse(boolean lazyCustomerPageEnabled, CheckedUser user, Project project, ServiceDesk serviceDesk) {
        CustomerPageResponse customerPageResponse = lazyCustomerPageEnabled ? CustomerPageResponse.lazyCustomerPageResponse() : CustomerPageResponse.eagerCustomerPageResponse();
        customerPageResponse.setCanAdministerJIRA(this.serviceDeskPermissions.canAdministerJIRA((SDUser)user));
        customerPageResponse.setCanAdminister(this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project));
        customerPageResponse.setCustomerRoleMisconfigured(this.permissionSchemeMisconfigurationService.isCustomerRoleCriticallyMisconfigured(project));
        customerPageResponse.setReadOnlyJIRA(!this.userManager.hasWritableDirectory());
        customerPageResponse.setOutgoingMailConfigured(this.serviceDeskNotificationInternalSender.isOutgoingMailConfigured());
        customerPageResponse.setCanInvite(this.customerServiceValidator.isUserAllowedInviteCustomers(user, project, serviceDesk));
        customerPageResponse.setCanManageOrganizations(this.customerOrganizationSettingService.canManageOrganizationsInProject(user, project));
        customerPageResponse.setExpandHelpBubble(this.getShouldShowExpandBubbleAndUpdateState(user, serviceDesk));
        boolean openAccess2 = this.internalServiceDeskAccessService.isOpenAccess(serviceDesk);
        boolean projectLevelSignUpSettingEnabled = this.internalServiceDeskAccessService.isProjectLevelSignupSettingEnabled(serviceDesk);
        customerPageResponse.setServiceDeskOpenAccess(openAccess2);
        customerPageResponse.setServiceDeskPublicSignUp(projectLevelSignUpSettingEnabled);
        return customerPageResponse;
    }

    @VisibleForTesting
    boolean getShouldShowExpandBubbleAndUpdateState(CheckedUser user, ServiceDesk serviceDesk) {
        boolean expandHelpBubble = this.onBoardingPropertiesService.shouldExpandAdminAgentHelpBubble("local.servicedesk.help.bubble.customers.page.shown", user.forJIRA(), serviceDesk);
        if (expandHelpBubble) {
            this.onBoardingPropertiesService.dismissAdminAgentHelpBubble("local.servicedesk.help.bubble.customers.page.shown", user.forJIRA(), serviceDesk);
        }
        return expandHelpBubble;
    }

    private LazyPagedResponse<CustomerSearchItemResult> transformToSearchItemResultPagedResponse(LazyPagedResponse<CheckedUser> users) {
        PagedResponse userPagedResponse = users.map(UserSearchItemResult::new);
        return LazyPagedResponseImpl.from(userPagedResponse, users.total());
    }
}

