/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest.admin;

import com.atlassian.fugue.Either;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskApplicationLicenseService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.admin.LicenseStatsResponse;
import io.atlassian.fugue.Unit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="/admin/licenseinfo")
public class LicenseStatsResource {
    private final GlobalPermissionManager globalPermissionManager;
    private final UserFactory userFactory;
    private final ServiceDeskApplicationLicenseService serviceDeskApplicationLicenseService;
    private final ErrorResultHelper errorResultHelper;
    private final RestResponseHelper restResponseHelper;

    public LicenseStatsResource(GlobalPermissionManager globalPermissionManager, UserFactory userFactory, ServiceDeskApplicationLicenseService serviceDeskApplicationLicenseService, ErrorResultHelper errorResultHelper, RestResponseHelper restResponseHelper) {
        this.globalPermissionManager = globalPermissionManager;
        this.userFactory = userFactory;
        this.serviceDeskApplicationLicenseService = serviceDeskApplicationLicenseService;
        this.errorResultHelper = errorResultHelper;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    @AnonymousAllowed
    public Response getLicenseInfo() {
        io.atlassian.fugue.Either licenseData = Steps.begin(this.checkAccess()).yield(unit -> this.getLicenseStats());
        return this.restResponseHelper.anErrorEitherToOkResponse(licenseData);
    }

    private LicenseStatsResponse getLicenseStats() {
        return new LicenseStatsResponse(this.serviceDeskApplicationLicenseService.getActiveAgentCount(), true);
    }

    private io.atlassian.fugue.Either<AnError, Unit> checkAccess() {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(this::checkAdminPermission).yield((user, unit) -> Unit.VALUE);
    }

    private io.atlassian.fugue.Either<AnError, Unit> checkAdminPermission(CheckedUser user) {
        if (this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user.forJIRA()) || this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user.forJIRA())) {
            return io.atlassian.fugue.Either.right((Object)Unit.VALUE);
        }
        return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.forbidden403("sd.admin.license.count.resource.no.permission", new Object[0]).build());
    }
}

