/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest;

import com.atlassian.lookandfeel.ColorScheme;
import com.atlassian.servicedesk.internal.feature.customer.portal.lookandfeel.Theme;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class ThemeResponse {
    private String headerBGColor;
    private String headerLinkColor;
    private String headerLinkHoverColor;
    private String headerLinkHoverBGColor;
    private String headerBadgeColor;

    public ThemeResponse() {
    }

    public ThemeResponse(String headerBGColor, String headerLinkColor, String headerLinkHoverColor, String headerLinkHoverBGColor, String headerBadgeColor) {
        this.headerBGColor = headerBGColor;
        this.headerLinkColor = headerLinkColor;
        this.headerLinkHoverColor = headerLinkHoverColor;
        this.headerLinkHoverBGColor = headerLinkHoverBGColor;
        this.headerBadgeColor = headerBadgeColor;
    }

    public static ThemeResponse getDefault() {
        return new ThemeResponse("#036", "#fff", "#fff", "#149", "#149");
    }

    public String getHeaderBGColor() {
        return this.headerBGColor;
    }

    public String getHeaderLinkColor() {
        return this.headerLinkColor;
    }

    public String getHeaderLinkHoverColor() {
        return this.headerLinkHoverColor;
    }

    public String getHeaderLinkHoverBGColor() {
        return this.headerLinkHoverBGColor;
    }

    public String getHeaderBadgeColor() {
        return this.headerBadgeColor;
    }

    public static ThemeResponse toThemeResponse(Theme theme) {
        if (theme == null) {
            return null;
        }
        ThemeResponse result = new ThemeResponse();
        result.headerBGColor = theme.getHeaderBGColor();
        result.headerLinkColor = theme.getHeaderLinkColor();
        result.headerLinkHoverColor = theme.getHeaderLinkHoverColor();
        result.headerLinkHoverBGColor = theme.getHeaderLinkHoverBGColor();
        result.headerBadgeColor = theme.getHeaderLinkHoverBGColor();
        return result;
    }

    public static ThemeResponse toThemeResponse(ColorScheme cs) {
        if (cs == null) {
            return null;
        }
        ThemeResponse result = new ThemeResponse();
        result.headerBGColor = cs.getHeader().getHexString();
        result.headerLinkColor = cs.getHeaderText().getHexString();
        result.headerLinkHoverColor = cs.getHeaderHighlightText().getHexString();
        result.headerLinkHoverBGColor = cs.getHeaderHighlight().getHexString();
        result.headerBadgeColor = cs.getHeaderHighlight().getHexString();
        return result;
    }
}

