/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.api.error.ErrorTranslationHelper;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.rest.responses.AppLinkResponse;
import com.atlassian.servicedesk.internal.rest.responses.AppLinkResponseHelper;
import com.atlassian.servicedesk.internal.rest.responses.AppLinksResponse;
import com.atlassian.servicedesk.plugins.coreui.internal.utils.HelpUrlHelper;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/servicedesk/{projectKey}/applinks")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ServiceDeskAppLinksResource {
    private static final Logger log = LoggerFactory.getLogger(ServiceDeskAppLinksResource.class);
    private final UserFactory userFactory;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final ServiceDeskAppLinkService serviceDeskAppLinkService;
    private final RestResponseHelper restResponseHelper;
    private final HelpUrlHelper helpUrlHelper;
    private final ApplicationLinkErrors applicationLinkErrors;
    private final ErrorTranslationHelper errorTranslationHelper;

    public ServiceDeskAppLinksResource(UserFactory userFactory, ServiceDeskProjectService serviceDeskProjectService, ServiceDeskAppLinkService serviceDeskAppLinkService, RestResponseHelper restResponseHelper, HelpUrlHelper helpUrlHelper, ApplicationLinkErrors applicationLinkErrors, ErrorTranslationHelper errorTranslationHelper) {
        this.userFactory = userFactory;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.serviceDeskAppLinkService = serviceDeskAppLinkService;
        this.restResponseHelper = restResponseHelper;
        this.helpUrlHelper = helpUrlHelper;
        this.applicationLinkErrors = applicationLinkErrors;
        this.errorTranslationHelper = errorTranslationHelper;
    }

    @GET
    @Path(value="/confluence")
    public Response getConfluenceAppLinks(@PathParam(value="projectKey") String projectKey, @DefaultValue(value="") @QueryParam(value="query") String query) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.serviceDeskAppLinkService.getAllApplicationLinksForType(user, project, ConfluenceApplicationType.class)).then((user, project, appLinks) -> io.atlassian.fugue.Either.right(this.searchAppLinksAndBuildResponses((CheckedUser)user, (Project)project, (List<ApplicationLink>)appLinks, query))).yield((user, project, appLinks, appLinkResponses) -> new AppLinksResponse((List<AppLinkResponse>)appLinkResponses));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private List<AppLinkResponse> searchAppLinksAndBuildResponses(CheckedUser user, Project project, List<ApplicationLink> appLinks, String query) {
        return appLinks.stream().filter(appLink -> StringUtils.containsIgnoreCase((String)appLink.getName(), (String)query)).map(appLink -> this.buildAppLinkResponse(user, (ApplicationLink)appLink, project)).collect(Collectors.toList());
    }

    private AppLinkResponse buildAppLinkResponse(CheckedUser user, ApplicationLink appLink, Project project) {
        return (AppLinkResponse)Steps.begin((io.atlassian.fugue.Either)this.serviceDeskAppLinkService.getAuthProvider(user, appLink, project)).then(authClass -> this.serviceDeskAppLinkService.validateConfluenceApplicationLink(authClass, appLink)).then((authClass, isValid) -> io.atlassian.fugue.Either.right((Object)this.serviceDeskAppLinkService.doesAuthTypeSupportImpersonation(authClass))).then((authClass, isValid, impersonationStatus) -> io.atlassian.fugue.Either.right((Object)AppLinkResponseHelper.buildValidAppLinkResponse(impersonationStatus, this.helpUrlHelper, appLink, authClass))).yield((authClass, isValid, impersonationStatus, appLinkResponse) -> appLinkResponse).fold(error -> AppLinkResponseHelper.buildInvalidAppLinkResponse(this.helpUrlHelper, this.errorTranslationHelper, appLink, error, user.i18NHelper()), Function.identity());
    }
}

