/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.api.webfragments.WebInterfaceBeanService;
import com.atlassian.servicedesk.internal.rest.sla.agentview.ServiceDeskSlaHelper;
import com.atlassian.servicedesk.internal.rest.sla.response.SlaReportPageResponse;
import com.atlassian.servicedesk.internal.web.contextprovider.ServiceDeskProjectContextProvider;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="pages/reports/{projectKey}")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ReportsPageResource {
    private static final String PERCENT_MET_FEATURE_DISCOVERY = "percent.met.feature.discovery.dismissed";
    private final ServiceDeskProjectContextProvider serviceDeskProjectContextProvider;
    private final UserFactory userFactory;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final InternalServiceDeskService internalServiceDeskService;
    private final WebInterfaceBeanService webInterfaceBeanService;
    private final ServiceDeskSlaHelper serviceDeskSlaHelper;
    private final RestResponseHelper restResponseHelper;
    private final UserPropertyManager userPropertyManager;

    public ReportsPageResource(ServiceDeskProjectContextProvider serviceDeskProjectContextProvider, UserFactory userFactory, InternalServiceDeskProjectManager internalServiceDeskProjectManager, InternalServiceDeskService internalServiceDeskService, WebInterfaceBeanService webInterfaceBeanService, ServiceDeskSlaHelper serviceDeskSlaHelper, RestResponseHelper restResponseHelper, UserPropertyManager userPropertyManager) {
        this.serviceDeskProjectContextProvider = serviceDeskProjectContextProvider;
        this.userFactory = userFactory;
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
        this.internalServiceDeskService = internalServiceDeskService;
        this.webInterfaceBeanService = webInterfaceBeanService;
        this.serviceDeskSlaHelper = serviceDeskSlaHelper;
        this.restResponseHelper = restResponseHelper;
        this.userPropertyManager = userPropertyManager;
    }

    @GET
    @Path(value="nav")
    public Response getNav(@PathParam(value="projectKey") String projectKey) {
        Map<String, Object> contextMap = this.serviceDeskProjectContextProvider.getContextMap(projectKey);
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskProjectManager.getProjectByKey(projectKey)).yield((user, project) -> this.webInterfaceBeanService.getWebSections("sd-reports-nav", contextMap));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @GET
    @Path(value="sla")
    public Response getSlaReport(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskProjectManager.getProjectByKey(projectKey)).then((user, project) -> this.internalServiceDeskService.getServiceDeskForProject(user, project, false)).yield((user, project, sd) -> new SlaReportPageResponse(this.serviceDeskSlaHelper.getTimeMetrics((CheckedUser)user, (ServiceDesk)sd, (Project)project), this.serviceDeskSlaHelper.getCalendars((CheckedUser)user, (ServiceDesk)sd)));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @POST
    @Path(value="sla/viewed")
    public Response markSlaReportFeatureDiscoveryAsViewed(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either user = StepsConverters.newerEither((Either)this.userFactory.getCheckedUser());
        if (user.isLeft()) {
            return this.restResponseHelper.anErrorToResponse((AnError)user.left().get());
        }
        this.setSlaGoalPageVisited(((CheckedUser)user.right().get()).forJIRA());
        return Response.ok().build();
    }

    private void setSlaGoalPageVisited(ApplicationUser user) {
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        propertySet.setBoolean(PERCENT_MET_FEATURE_DISCOVERY, true);
    }
}

