/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.NamedErrors;
import com.atlassian.servicedesk.internal.api.onboarding.OnBoardingPropertiesService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueService;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.feature.queue.ProjectState;
import com.atlassian.servicedesk.internal.feature.queue.ProjectStateCacheManager;
import com.atlassian.servicedesk.internal.feature.queue.QueueInternal;
import com.atlassian.servicedesk.internal.feature.queue.QueueRequest;
import com.atlassian.servicedesk.internal.feature.queue.QueueServiceInternal;
import com.atlassian.servicedesk.internal.feature.servicedesk.history.ServiceDeskUserHistoryService;
import com.atlassian.servicedesk.internal.rest.requests.QueueBulkSaveRequest;
import com.atlassian.servicedesk.internal.rest.requests.QueueSaveRequest;
import com.atlassian.servicedesk.internal.rest.requests.RESTfulTableReorderRequest;
import com.atlassian.servicedesk.internal.rest.responses.queue.QueueLimitResponse;
import com.atlassian.servicedesk.internal.rest.responses.queue.QueueListResponse;
import com.atlassian.servicedesk.internal.rest.responses.queue.QueueParams;
import com.atlassian.servicedesk.internal.rest.responses.queue.QueueResponse;
import com.atlassian.servicedesk.internal.rest.util.ReorderQueuesHelper;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="/servicedesk/{projectKey}/queues")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class QueueResourceInternal {
    private static final String QUEUE_REORDER_FIRST = "First";
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final QueueServiceInternal queueService;
    private final ServiceDeskIssueService serviceDeskIssueService;
    private final ServiceDeskService serviceDeskService;
    private final OnBoardingPropertiesService onBoardingPropertiesService;
    private final ProjectStateCacheManager projectStateCache;
    private final ServiceDeskUserHistoryService serviceDeskHistoryService;
    private final UserFactory userFactory;
    private final RestResponseHelper restResponseHelper;
    private final ErrorResultHelper errorResultHelper;

    public QueueResourceInternal(ServiceDeskProjectService serviceDeskProjectService, QueueServiceInternal queueService, ServiceDeskIssueService serviceDeskIssueService, ServiceDeskService serviceDeskService, OnBoardingPropertiesService onBoardingPropertiesService, ProjectStateCacheManager projectStateCache, ServiceDeskUserHistoryService serviceDeskHistoryService, UserFactory userFactory, RestResponseHelper restResponseHelper, ErrorResultHelper errorResultHelper) {
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.queueService = queueService;
        this.serviceDeskIssueService = serviceDeskIssueService;
        this.serviceDeskService = serviceDeskService;
        this.onBoardingPropertiesService = onBoardingPropertiesService;
        this.projectStateCache = projectStateCache;
        this.serviceDeskHistoryService = serviceDeskHistoryService;
        this.userFactory = userFactory;
        this.restResponseHelper = restResponseHelper;
        this.errorResultHelper = errorResultHelper;
    }

    @POST
    public Response addQueue(@PathParam(value="projectKey") String projectKey, QueueSaveRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.addQueue((CheckedUser)user, (Project)project, projectKey, request)).yield((user, project, namedErrorsOrQueue) -> namedErrorsOrQueue.map(queue -> this.createQueueResponse((QueueInternal)queue, (CheckedUser)user, (Project)project)));
        return (Response)result.fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), arg_0 -> ((RestResponseHelper)this.restResponseHelper).namedErrorsEitherToOkResponse(arg_0));
    }

    @PUT
    public Response updateQueues(@PathParam(value="projectKey") String projectKey, QueueBulkSaveRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).yield((user, project) -> this.updateQueues((CheckedUser)user, (Project)project, request));
        return (Response)result.fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), resp -> resp);
    }

    @POST
    @Path(value="/{id}/move")
    public Response reorderQueues(@PathParam(value="projectKey") String projectKey, @PathParam(value="id") long queueId, RESTfulTableReorderRequest reorderRequest) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.queueService.getQueue(queueId, (CheckedUser)user, (Project)project)).then((user, project, queue) -> this.extractAfterOptionFromReorderRequest(reorderRequest)).then((user, project, queue, lastOpt) -> this.queueService.reorderQueues(queueId, lastOpt.orElse(-1L), (CheckedUser)user, (Project)project)).yield((user, project, queue, lastOpt, reorderResult) -> Unit.Unit());
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @GET
    @Path(value="/poll")
    public Response pollQueueChanges(@PathParam(value="projectKey") String projectKey, @QueryParam(value="projectStateHash") String projectStateHash) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).leftMap(err -> this.userSessionTimedOutQueuePolling())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).yield((user, project) -> this.checkProjectHashChange(projectStateHash, (Project)project));
        return (Response)result.fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), projectHashChange -> (Response)projectHashChange.fold(() -> Response.notModified().build(), arg_0 -> ((RestResponseHelper)this.restResponseHelper).ok(arg_0)));
    }

    @GET
    @Path(value="/page")
    public Response getQueuePageParams(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), project))).then((user, project, serviceDesk) -> this.queueService.getQueuesForProject((CheckedUser)user, (Project)project)).yield((user, project, serviceDesk, queues) -> this.buildQueueParams((List<QueueInternal>)queues, (CheckedUser)user, (Project)project, (ServiceDesk)serviceDesk));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @GET
    @Path(value="/queues-limit")
    public Response getQueuesLimit() {
        int limit = this.queueService.getQueuesLimitForProject();
        return this.restResponseHelper.ok((Object)new QueueLimitResponse(limit));
    }

    @PUT
    @Path(value="/{id}")
    public Response updateQueue(@PathParam(value="projectKey") String projectKey, @PathParam(value="id") long queueId, QueueSaveRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.serviceDeskProjectService.getProjectByKey((CheckedUser)user, projectKey)).then((user, project) -> this.queueService.getQueue(queueId, (CheckedUser)user, (Project)project)).then((user, project, queue) -> this.updateQueue(queueId, (QueueInternal)queue, (CheckedUser)user, (Project)project, request)).yield((user, project, queue, namedErrorsOrQueue) -> namedErrorsOrQueue.map(updatedQueue -> this.createQueueResponse((QueueInternal)updatedQueue, (CheckedUser)user, (Project)project)));
        return (Response)result.fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), arg_0 -> ((RestResponseHelper)this.restResponseHelper).namedErrorsEitherToOkResponse(arg_0));
    }

    private Response updateQueues(CheckedUser user, Project project, QueueBulkSaveRequest request) {
        Response response;
        for (long queueIdToDelete : request.getDeleted()) {
            response = this.deleteQueue(queueIdToDelete, user, project);
            if (response.getStatus() == 200) continue;
            return response;
        }
        List<ReorderQueuesHelper.ReorderOperation> reordersToDo = ReorderQueuesHelper.determineReordersToDo(this.getCurrentQueuesOrder(user, project), request.getOrder());
        for (ReorderQueuesHelper.ReorderOperation reorderOperation : reordersToDo) {
            response = this.reorderQueue(reorderOperation.getQueueId(), user, project, reorderOperation.getQueueAboveId());
            if (response.getStatus() == 200) continue;
            return response;
        }
        return this.getQueues(user, project);
    }

    private List<Long> getCurrentQueuesOrder(CheckedUser user, Project project) {
        return ((List)this.queueService.getQueuesForProject(user, project).getOrElse(Collections.emptyList())).stream().map(QueueInternal::getId).collect(Collectors.toList());
    }

    private Response deleteQueue(long queueId, CheckedUser user, Project project) {
        io.atlassian.fugue.Either result = Steps.begin(this.queueService.getQueue(queueId, user, project)).then(queue -> this.queueService.deleteQueue(queueId, user, project)).yield((queue, deletedQueue) -> this.createQueueResponse((QueueInternal)deletedQueue, user, project));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private Response reorderQueue(long queueId, CheckedUser user, Project project, long queueAboveId) {
        io.atlassian.fugue.Either result = this.queueService.getQueue(queueId, user, project).flatMap(queue -> this.queueService.reorderQueues(queueId, queueAboveId, user, project)).map(queueInternal -> Unit.Unit());
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private io.atlassian.fugue.Either<AnError, OptionalLong> extractAfterOptionFromReorderRequest(RESTfulTableReorderRequest reorderRequest) {
        if (QUEUE_REORDER_FIRST.equals(reorderRequest.getPosition())) {
            return io.atlassian.fugue.Either.right((Object)OptionalLong.empty());
        }
        if (StringUtils.isNotEmpty((String)reorderRequest.getAfter())) {
            String[] queueAboveIdSplit = reorderRequest.getAfter().split("/");
            long last = -1L;
            try {
                if (queueAboveIdSplit.length > 0) {
                    last = Long.valueOf(queueAboveIdSplit[queueAboveIdSplit.length - 1]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return io.atlassian.fugue.Either.right((Object)OptionalLong.of(last));
        }
        return io.atlassian.fugue.Either.left((Object)this.queueReorderFailure());
    }

    private Response getQueues(CheckedUser user, Project project) {
        io.atlassian.fugue.Either result = Steps.begin(this.queueService.getQueuesForProject(user, project)).yield(queues -> queues.stream().map(queue -> this.createQueueResponse((QueueInternal)queue, user, project)).collect(Collectors.toList()));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<NamedErrors, QueueInternal>> updateQueue(long queueId, QueueInternal queue, CheckedUser user, Project project, QueueSaveRequest request) {
        return this.queueService.updateQueue(queueId, user, project, new QueueRequest(project.getId(), queue.getProjectKey(), (Option<String>)request.getName().orElse(Option.some((Object)queue.getName())), (Option<String>)request.getJql().orElse(Option.some((Object)queue.getJql())), (Option<Integer>)Option.some((Object)queue.getOrder()), (Option<List<String>>)request.getColumns().orElse(Option.some(queue.getColumns()))));
    }

    private QueueParams buildQueueParams(List<QueueInternal> queues, CheckedUser user, Project project, ServiceDesk serviceDesk) {
        List<QueueResponse> queuesResponseList = queues.stream().map(queue -> this.createQueueResponse((QueueInternal)queue, user, project)).collect(Collectors.toList());
        boolean expandHelpBubble = this.onBoardingPropertiesService.shouldExpandAdminAgentHelpBubble("local.servicedesk.help.bubble.queues.page.shown", user.forJIRA(), serviceDesk);
        if (expandHelpBubble) {
            this.onBoardingPropertiesService.dismissAdminAgentHelpBubble("local.servicedesk.help.bubble.queues.page.shown", user.forJIRA(), serviceDesk);
        }
        boolean welcomeGuideItemAlreadyCompleted = this.onBoardingPropertiesService.isChecklistItemCompleted(user.forJIRA(), "view-issue");
        this.serviceDeskHistoryService.addProjectToHistory(user, project);
        return new QueueParams(queuesResponseList, expandHelpBubble, welcomeGuideItemAlreadyCompleted);
    }

    @Nonnull
    private Option<QueueListResponse> checkProjectHashChange(String clientHash, Project project) {
        ProjectState currentProjectState = this.projectStateCache.getProjectState(project);
        String serverHash = String.valueOf(currentProjectState.hashCode());
        if (clientHash == null || !Objects.equals(clientHash, serverHash)) {
            return Option.some((Object)new QueueListResponse(serverHash));
        }
        return Option.none();
    }

    private io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<NamedErrors, QueueInternal>> addQueue(CheckedUser user, Project project, String projectKey, QueueSaveRequest request) {
        return this.queueService.addQueue(new QueueRequest(project.getId(), projectKey, request.getName(), (Option<String>)request.getJql().orElse(Option.some((Object)"")), (Option<Integer>)Option.some((Object)this.queueService.countQueues(project)), request.getColumns()), user, project);
    }

    private QueueResponse createQueueResponse(QueueInternal queue, CheckedUser user, Project project) {
        String completeJql = this.serviceDeskIssueService.limitToProject(user, queue.getJql(), project);
        return new QueueResponse(queue.getId(), queue.getProjectKey(), queue.getName(), queue.getJql(), completeJql, queue.getOrder(), queue.getColumns());
    }

    private AnError queueReorderFailure() {
        return this.errorResultHelper.badRequest400("sd.admin.queue.general.error.reorderfailure", new Object[0]).build();
    }

    private AnError userSessionTimedOutQueuePolling() {
        return this.errorResultHelper.unauthorized401("sd.admin.queue.poll.error.session.timedout", new Object[0]).build();
    }
}

