/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest;

import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.rest.responses.JqlAutoCompleteResponse;
import java.util.Locale;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/jqlAutoComplete")
@AnonymousAllowed
@Produces(value={"application/json"})
public class JqlAutoCompleteResource {
    private final HelpUrls helpUrls;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final AutoCompleteJsonGenerator autoCompleteJsonGenerator;
    private final RestResponseHelper restResponseHelper;

    public JqlAutoCompleteResource(HelpUrls helpUrls, JiraAuthenticationContext jiraAuthenticationContext, AutoCompleteJsonGenerator autoCompleteJsonGenerator, RestResponseHelper restResponseHelper) {
        this.helpUrls = helpUrls;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.autoCompleteJsonGenerator = autoCompleteJsonGenerator;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    public Response getAutoCompleteData() throws JSONException {
        HelpUrl advancedSearch = this.helpUrls.getUrl("advanced_search");
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        Locale locale = this.jiraAuthenticationContext.getLocale();
        JqlAutoCompleteResponse response = new JqlAutoCompleteResponse(this.autoCompleteJsonGenerator.getVisibleFieldNamesJson(user, locale), this.autoCompleteJsonGenerator.getVisibleFunctionNamesJson(user, locale), this.autoCompleteJsonGenerator.getJqlReservedWordsJson(), advancedSearch.getUrl(), advancedSearch.getTitle());
        return this.restResponseHelper.ok((Object)response);
    }
}

