/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.feature.customer.user.signup.GlobalPublicSignupService;
import io.atlassian.fugue.Unit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/admin/global-public-signup")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class GlobalPublicSignupResource {
    private final UserFactory userFactory;
    private final GlobalPublicSignupService globalPublicSignupService;
    private final RestResponseHelper restResponseHelper;

    public GlobalPublicSignupResource(UserFactory userFactory, GlobalPublicSignupService globalPublicSignupService, RestResponseHelper restResponseHelper) {
        this.userFactory = userFactory;
        this.globalPublicSignupService = globalPublicSignupService;
        this.restResponseHelper = restResponseHelper;
    }

    @PUT
    public Response enablePublicSignup() {
        return this.setGlobalPublicSignup(true);
    }

    @DELETE
    public Response disablePublicSignup() {
        return this.setGlobalPublicSignup(false);
    }

    private Response setGlobalPublicSignup(boolean value) {
        return this.restResponseHelper.anErrorEitherToNoContentResponse(StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).flatMap(user -> this.globalPublicSignupService.setGlobalPublicSignup((CheckedUser)user, value)).map(bool -> Unit.Unit()));
    }
}

