/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.notifications.GlobalNotificationsInternalManager;
import io.atlassian.fugue.Unit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/servicedesk/global-notification")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@WebSudoRequired
public class GlobalNotificationResource {
    private final UserFactory userFactory;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final GlobalNotificationsInternalManager globalNotificationsManager;
    private final ErrorResultHelper errorResultHelper;
    private final RestResponseHelper restResponseHelper;

    GlobalNotificationResource(UserFactory userFactory, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, GlobalNotificationsInternalManager globalNotificationsManager, ErrorResultHelper errorResultHelper, RestResponseHelper restResponseHelper) {
        this.userFactory = userFactory;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.globalNotificationsManager = globalNotificationsManager;
        this.errorResultHelper = errorResultHelper;
        this.restResponseHelper = restResponseHelper;
    }

    @POST
    public Response enableGlobalNotifications() {
        return this.setAdminGlobalNotificationDisabled(false);
    }

    @DELETE
    public Response disableGlobalNotifications() {
        return this.setAdminGlobalNotificationDisabled(true);
    }

    private Response setAdminGlobalNotificationDisabled(boolean value) {
        return this.restResponseHelper.anErrorEitherToNoContentResponse(StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).flatMap(user -> this.setAdminGlobalNotificationDisabled((CheckedUser)user, value)));
    }

    private io.atlassian.fugue.Either<AnError, Unit> setAdminGlobalNotificationDisabled(CheckedUser user, boolean value) {
        if (!this.serviceDeskLicenseAndPermissionService.canAdministerJIRA((SDUser)user)) {
            return io.atlassian.fugue.Either.left((Object)this.createForbiddenError());
        }
        this.globalNotificationsManager.setNotificationDisabled(value);
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    private AnError createForbiddenError() {
        return this.errorResultHelper.forbidden403("sd.admin.servicedesk.configuration.permission.violation", new Object[0]).build();
    }
}

