/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.rest;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarFormatPolicy;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.io.MediaConsumer;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.feature.customer.request.avatar.SDAgentAvatarService;
import com.atlassian.servicedesk.internal.utils.RichResponseBuilder;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Suppliers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.function.Supplier;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/servicedesk/customer/avatar")
public class AgentAvatarResource {
    private static final Logger log = LoggerFactory.getLogger(AgentAvatarResource.class);
    private final SDAgentAvatarService agentAvatarService;
    private final AvatarManager avatarManager;
    private final AvatarService avatarService;
    private final UserFactory userFactory;
    private final Supplier<Response> notFoundSupplier;

    protected AgentAvatarResource(SDAgentAvatarService agentAvatarService, AvatarManager avatarManager, AvatarService avatarService, UserFactory userFactory) {
        this.agentAvatarService = agentAvatarService;
        this.avatarManager = avatarManager;
        this.avatarService = avatarService;
        this.userFactory = userFactory;
        this.notFoundSupplier = Suppliers.ofInstance((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Image is not found").build());
    }

    @GET
    @Path(value="{avatarId}")
    public Response getAvatar(@PathParam(value="avatarId") Long id, @QueryParam(value="size") String size, @QueryParam(value="format") String format) {
        return (Response)this.agentAvatarService.getAvatar(id, this.userFactory.getUncheckedUser()).fold(this.notFoundSupplier, avatarFile -> {
            Avatar.Size imageSize = (Avatar.Size)Option.option((Object)size).flatMap(param -> {
                try {
                    return Option.option((Object)Avatar.Size.getSizeFromParam((String)param));
                }
                catch (RuntimeException re) {
                    return Option.none();
                }
            }).getOr(Avatar.Size::defaultSize);
            ApplicationUser avatarUser = (ApplicationUser)this.userFactory.wrapUserKey(avatarFile.getOwner()).map(CheckedUser::forJIRA).getOrNull();
            if (this.avatarService.isUsingExternalAvatar(avatarUser, avatarUser)) {
                return Response.seeOther((URI)this.avatarService.getAvatarUrlNoPermCheck(avatarUser, imageSize)).build();
            }
            Response.ResponseBuilder builder = new RichResponseBuilder(Response.ok()).cacheForeverPrivatelyAndAllowTransform();
            try {
                this.avatarManager.readAvatarData(avatarFile, imageSize, this.toAvatarFormatPolicy((Option<String>)Option.option((Object)format)), new MediaConsumer(arg_0 -> ((Response.ResponseBuilder)builder).type(arg_0), is -> {
                    try {
                        byte[] avatarBytes = IOUtils.toByteArray((InputStream)is);
                        builder.entity(os -> {
                            try {
                                IOUtils.write((byte[])avatarBytes, (OutputStream)os);
                            }
                            catch (IOException | RuntimeException e) {
                                log.error("Received an error while attempting to stream the avatar image ID " + id, (Throwable)e);
                            }
                        });
                    }
                    catch (IOException | RuntimeException ex) {
                        log.error("Received an error while attempting to read the avatar image ID " + id, (Throwable)ex);
                    }
                }));
            }
            catch (IOException e) {
                log.error("Received an error from the AvatarManager while trying to access avatar data for ID " + id, (Throwable)e);
                throw new RuntimeException(e);
            }
            return builder.build();
        });
    }

    private AvatarFormatPolicy toAvatarFormatPolicy(Option<String> imageFormat) {
        return (AvatarFormatPolicy)imageFormat.flatMap(fmt -> Option.option((Object)StringUtils.upperCase((String)fmt))).map(format -> {
            switch (format) {
                case "PNG": {
                    return AvatarFormatPolicy.createPngFormatPolicy().withFallingBackToOriginalDataStrategy();
                }
            }
            return AvatarFormatPolicy.createOriginalDataPolicy();
        }).getOrElse((Object)AvatarFormatPolicy.createOriginalDataPolicy());
    }
}

