/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.requesttype.group;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestTypeGroup;
import com.atlassian.servicedesk.internal.requesttype.group.RequestTypeGroupQStore;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupValidator {
    private final ErrorResultHelper errorResultHelper;
    private final RequestTypeGroupQStore requestTypeGroupQStore;

    @Autowired
    public GroupValidator(ErrorResultHelper errorResultHelper, RequestTypeGroupQStore requestTypeGroupQStore) {
        this.errorResultHelper = errorResultHelper;
        this.requestTypeGroupQStore = requestTypeGroupQStore;
    }

    public AnError validateGroupName(String name, Portal portal) {
        if (StringUtils.isBlank((String)name)) {
            return this.errorResultHelper.badRequest400("sd.admin.request.groups.add.name.required.error", new Object[0]).build();
        }
        if (name.length() > 127) {
            return this.errorResultHelper.badRequest400("sd.admin.request.groups.add.name.too.long.error", new Object[0]).build();
        }
        List<RequestTypeGroup> groupsForPortal = this.requestTypeGroupQStore.getGroups(portal);
        boolean exists = groupsForPortal.stream().anyMatch(group -> group.getName().toLowerCase().equals(name.toLowerCase().trim()));
        if (exists) {
            return this.errorResultHelper.badRequest400("sd.admin.request.groups.add.name.duplicate.error", new Object[0]).build();
        }
        return null;
    }
}

