/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.requesttype.group;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternal;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.requesttypegroup.GroupToRequestType;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.atlassian.servicedesk.internal.requesttype.group.GroupToRequestTypeQStore;
import com.atlassian.servicedesk.internal.requesttype.group.RequestTypeQstoreHelper;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class GroupToRequestTypeQStoreImpl
implements GroupToRequestTypeQStore {
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public GroupToRequestTypeQStoreImpl(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public void associateGroupToRequestType(int requestTypeId, int groupId) {
        this.databaseAccessor.run(conn -> (Integer)conn.insert((RelationalPath)Tables.GROUP_TO_REQUEST_TYPE).set(Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID, (Object)groupId).set(Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID, (Object)requestTypeId).executeWithKey(Tables.GROUP_TO_REQUEST_TYPE.ID));
    }

    @Override
    public List<GroupToRequestType> getGroupToRequestType(int portalId) {
        return (List)this.databaseAccessor.run(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select(GroupToRequestTypeQStoreImpl.mapper()).from((Expression)Tables.GROUP_TO_REQUEST_TYPE)).join((EntityPath)Tables.REQUEST_TYPE_GROUP)).on((Predicate)Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID.eq(Tables.REQUEST_TYPE_GROUP.ID))).join((EntityPath)Tables.REQUEST_TYPE)).on((Predicate)Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID.eq(Tables.REQUEST_TYPE.ID))).where((Predicate)Tables.REQUEST_TYPE.VIEWPORT_ID.eq((Object)portalId).and((Predicate)Tables.REQUEST_TYPE_GROUP.DELETED_TIME.isNull()))).fetch());
    }

    @Override
    public int updateOrderForRequestTypesInGroup(List<RequestTypeInternal> requestTypes, int groupId) {
        return (Integer)this.databaseAccessor.runInTransaction(databaseConnection -> {
            int newOrder = 0;
            SQLUpdateClause update = databaseConnection.update((RelationalPath)Tables.GROUP_TO_REQUEST_TYPE);
            for (RequestType requestType : requestTypes) {
                update.set(Tables.GROUP_TO_REQUEST_TYPE.ORDER, (Object)newOrder).where(new Predicate[]{Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID.eq((Object)groupId), Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID.eq((Object)requestType.getId())}).addBatch();
                ++newOrder;
            }
            update.execute();
            return newOrder;
        });
    }

    public static ConstructorExpression<GroupToRequestType> mapper() {
        return Projections.constructor(GroupToRequestType.class, (Expression[])new Expression[]{Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID, Tables.REQUEST_TYPE_GROUP.GROUP_NAME, Tables.REQUEST_TYPE_GROUP.ORDER, Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID, Tables.GROUP_TO_REQUEST_TYPE.ORDER});
    }

    @Override
    public void disassociateAllGroupsFromRequestType(RequestType requestType) {
        this.databaseAccessor.run(conn -> conn.delete((RelationalPath)Tables.GROUP_TO_REQUEST_TYPE).where((Predicate)Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID.eq((Object)requestType.getId())).execute());
    }

    @Override
    public void disassociateGroupToRequestType(int requestTypeId, int groupId) {
        this.databaseAccessor.run(conn -> conn.delete((RelationalPath)Tables.GROUP_TO_REQUEST_TYPE).where((Predicate)Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID.eq((Object)groupId).and((Predicate)Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID.eq((Object)requestTypeId))).execute());
    }

    @Override
    public Map<Integer, List<Integer>> getGroupToRequestTypeOrderMapping(int portalId) {
        return (Map)this.databaseAccessor.run(conn -> (Map)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select(Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID).from((Expression)Tables.GROUP_TO_REQUEST_TYPE)).join((EntityPath)Tables.REQUEST_TYPE)).on((Predicate)Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID.eq(Tables.REQUEST_TYPE.ID))).where((Predicate)Tables.REQUEST_TYPE.VIEWPORT_ID.eq((Object)portalId).and((Predicate)RequestTypeQstoreHelper.CORRECT_ISSUE_TYPE_CONDITION))).orderBy(new OrderSpecifier[]{Tables.GROUP_TO_REQUEST_TYPE.ORDER.asc(), Tables.REQUEST_TYPE.FORM_ORDER.asc(), Tables.REQUEST_TYPE.NAME.asc()})).transform(GroupBy.groupBy(Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID).as((Expression)GroupBy.list(Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID))));
    }

    @Override
    public List<Integer> getRequestTypeIDsInSortedOrderForGroup(int groupId) {
        return (List)this.databaseAccessor.run(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select(Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID).from((Expression)Tables.GROUP_TO_REQUEST_TYPE)).join((EntityPath)Tables.REQUEST_TYPE)).on((Predicate)Tables.GROUP_TO_REQUEST_TYPE.REQUEST_TYPE_ID.eq(Tables.REQUEST_TYPE.ID))).where((Predicate)Tables.GROUP_TO_REQUEST_TYPE.GROUP_ID.eq((Object)groupId).and((Predicate)RequestTypeQstoreHelper.CORRECT_ISSUE_TYPE_CONDITION))).orderBy(new OrderSpecifier[]{Tables.GROUP_TO_REQUEST_TYPE.ORDER.asc(), Tables.REQUEST_TYPE.FORM_ORDER.asc(), Tables.REQUEST_TYPE.NAME.asc()})).fetch());
    }
}

