/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.requesttype.group;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.requesttype.RequestTypeGroup;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class GroupOrderHelper {
    public static Either<AnError, List<RequestTypeGroup>> reorderGroups(List<RequestTypeGroup> groups, int[] order, ErrorResultHelper errorHelper) {
        Map<Integer, RequestTypeGroup> groupsById = groups.stream().collect(Collectors.toMap(RequestTypeGroup::getId, q -> q));
        Set<Integer> existingIdSet = groupsById.keySet();
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < order.length; ++i) {
            if (!existingIdSet.contains(order[i])) continue;
            result.add(groupsById.get(order[i]).withOrder(StepsConverters.olderOption((Option)Option.some((Object)i))));
            existingIdSet.remove(order[i]);
        }
        for (Integer id : existingIdSet) {
            result.add(groupsById.get(id));
        }
        return Either.right((Object)result);
    }

    public static List<RequestTypeGroup> assignOrder(List<RequestTypeGroup> groups) {
        ArrayList result = Lists.newArrayList();
        int order = 0;
        for (RequestTypeGroup group : groups) {
            result.add(group.withOrder(StepsConverters.olderOption((Option)Option.option((Object)order))));
            ++order;
        }
        return result;
    }
}

