/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.project.type;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeUpdatedHandler;
import com.atlassian.jira.project.type.ProjectTypeUpdatedOutcome;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.project.type.ServiceDeskProjectType;
import com.atlassian.servicedesk.internal.project.type.ServiceDeskProjectHelper;
import com.atlassian.servicedesk.internal.project.type.ServiceDeskProjectTypeUpdatedOutcome;
import io.atlassian.fugue.Either;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@Component
public class ServiceDeskProjectTypeUpdatedHandler
implements ProjectTypeUpdatedHandler {
    private static final String SD_PROJECT_TYPE_UPDATED_HANDLER_ID = "servicedesk-project-type-updated-handler";
    private final ServiceDeskProjectHelper sdProjectHelper;

    @Autowired
    public ServiceDeskProjectTypeUpdatedHandler(ServiceDeskProjectHelper sdProjectHelper) {
        this.sdProjectHelper = sdProjectHelper;
    }

    public String getHandlerId() {
        return SD_PROJECT_TYPE_UPDATED_HANDLER_ID;
    }

    public ProjectTypeUpdatedOutcome onProjectTypeUpdated(ApplicationUser user, Project project, ProjectTypeKey oldProjectTypeKey, ProjectTypeKey newProjectTypeKey) {
        boolean convertedToServiceDesk = newProjectTypeKey.equals((Object)ServiceDeskProjectType.KEY);
        boolean convertedFromServiceDesk = oldProjectTypeKey.equals((Object)ServiceDeskProjectType.KEY);
        if (convertedToServiceDesk) {
            Either<AnError, Boolean> convertResult = this.sdProjectHelper.convertToServiceDesk(user, project);
            return ServiceDeskProjectTypeUpdatedOutcome.builder().successful(convertResult.isRight()).serviceDeskWasCreated((Boolean)convertResult.right().getOrElse((Object)false)).build();
        }
        if (convertedFromServiceDesk) {
            boolean disableResult = this.sdProjectHelper.disableServiceDesk(project);
            return ServiceDeskProjectTypeUpdatedOutcome.builder().successful(disableResult).serviceDeskWasCreated(false).build();
        }
        return ServiceDeskProjectTypeUpdatedOutcome.builder().successful(true).serviceDeskWasCreated(false).build();
    }

    public void onProjectTypeUpdateRolledBack(ApplicationUser user, Project project, ProjectTypeKey oldProjectTypeKey, ProjectTypeKey newProjectTypeKey, ProjectTypeUpdatedOutcome outcome) {
        if (!(outcome instanceof ServiceDeskProjectTypeUpdatedOutcome)) {
            throw new RuntimeException("Expected outcome to be of type ServiceDeskProjectTypeUpdatedOutcome.");
        }
        ServiceDeskProjectTypeUpdatedOutcome sdOutcome = (ServiceDeskProjectTypeUpdatedOutcome)outcome;
        boolean convertedToServiceDesk = newProjectTypeKey.equals((Object)ServiceDeskProjectType.KEY);
        if (convertedToServiceDesk) {
            if (sdOutcome.serviceDeskWasCreated()) {
                this.sdProjectHelper.deleteServiceDesk(project);
            } else {
                this.sdProjectHelper.disableServiceDesk(project);
            }
        }
    }
}

