/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.project.type;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.feature.gettingstarted.GettingStartedService;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskDeletionManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskProjectHelper {
    private final GettingStartedService gettingStartedService;
    private final ServiceDeskInternalManager serviceDeskInternalManager;
    private final ServiceDeskDeletionManager serviceDeskDeletionManager;
    private final UserFactory userFactory;

    @Autowired
    public ServiceDeskProjectHelper(GettingStartedService gettingStartedService, ServiceDeskInternalManager serviceDeskInternalManager, ServiceDeskDeletionManager serviceDeskDeletionManager, UserFactory userFactory) {
        this.gettingStartedService = gettingStartedService;
        this.serviceDeskInternalManager = serviceDeskInternalManager;
        this.serviceDeskDeletionManager = serviceDeskDeletionManager;
        this.userFactory = userFactory;
    }

    public io.atlassian.fugue.Either<AnError, Boolean> createServiceDeskForSharedConfigProject(Project project) {
        io.atlassian.fugue.Either userResult = StepsConverters.newerEither((Either)this.userFactory.getCheckedUser());
        if (userResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)userResult.left().get());
        }
        CheckedUser checkedUser = (CheckedUser)userResult.right().get();
        io.atlassian.fugue.Either<AnError, ServiceDesk> serviceDeskResult = this.gettingStartedService.createServiceDeskWithSharedConfig(checkedUser, project);
        if (serviceDeskResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)serviceDeskResult.left().get());
        }
        return io.atlassian.fugue.Either.right((Object)true);
    }

    public io.atlassian.fugue.Either<AnError, Boolean> convertToServiceDesk(ApplicationUser user, Project project) {
        io.atlassian.fugue.Either userEither = StepsConverters.newerEither((Either)this.userFactory.wrap(user));
        if (userEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)userEither.left().get());
        }
        CheckedUser checkedUser = (CheckedUser)userEither.right().get();
        boolean serviceDeskAlreadyExists = this.serviceDeskInternalManager.getServiceDesk(project, true).isRight();
        io.atlassian.fugue.Either<AnError, ServiceDesk> sdEither = this.gettingStartedService.convertToServiceDesk(checkedUser, project);
        if (sdEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)sdEither.left().get());
        }
        boolean createdServiceDesk = !serviceDeskAlreadyExists;
        return io.atlassian.fugue.Either.right((Object)createdServiceDesk);
    }

    public boolean disableServiceDesk(Project project) {
        io.atlassian.fugue.Either<AnError, ServiceDesk> sdEither = this.serviceDeskInternalManager.getServiceDesk(project, true);
        if (sdEither.isLeft()) {
            return true;
        }
        ServiceDesk serviceDesk = (ServiceDesk)sdEither.right().get();
        return this.serviceDeskDeletionManager.cleanupServiceDesk(serviceDesk).isRight();
    }

    public boolean deleteServiceDesk(Project project) {
        return this.serviceDeskDeletionManager.deleteServiceDeskByProject(project.getId(), project.getKey()).isRight();
    }
}

