/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.permission.security;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.customfields.participants.ParticipantsCustomFieldManager;
import com.atlassian.servicedesk.internal.spi.permission.security.CustomerInvolvedType;
import com.atlassian.servicedesk.internal.spi.permission.security.RequestAccessUserStrategy;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestParticipantRequestAccessUserStrategy
implements RequestAccessUserStrategy {
    private final UserFactory userFactory;
    private final ParticipantsCustomFieldManager participantsCustomFieldManager;

    @Autowired
    public RequestParticipantRequestAccessUserStrategy(UserFactory userFactory, ParticipantsCustomFieldManager participantsCustomFieldManager) {
        this.userFactory = userFactory;
        this.participantsCustomFieldManager = participantsCustomFieldManager;
    }

    public List<CheckedUser> getUsers(@Nonnull Issue issue) {
        return ImmutableList.copyOf((Collection)((Collection)this.participantsCustomFieldManager.getUserParticipantsFromIssue(issue).getOrElse(Collections.emptySet())));
    }

    public CustomerInvolvedType getType() {
        return CustomerInvolvedType.REQUEST_PARTICIPANT;
    }

    public boolean match(ApplicationUser user, Issue issue) {
        return this.userFactory.wrap(user).exists(checkedUser -> this.getUsers(issue).contains(checkedUser));
    }
}

