/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.permission.security;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.permission.security.CustomerOrganisationParticipantRequestAccessUserStrategy;
import com.atlassian.servicedesk.internal.permission.security.CustomerOutsiderRequestAccessUserStrategy;
import com.atlassian.servicedesk.internal.permission.security.ReporterRequestAccessUserStrategy;
import com.atlassian.servicedesk.internal.permission.security.RequestAccessUserStrategyManager;
import com.atlassian.servicedesk.internal.permission.security.RequestParticipantRequestAccessUserStrategy;
import com.atlassian.servicedesk.internal.spi.permission.security.CustomerInvolvedType;
import com.atlassian.servicedesk.internal.spi.permission.security.RequestAccessUserProviderRegistry;
import com.atlassian.servicedesk.internal.spi.permission.security.RequestAccessUserStrategy;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
class RequestAccessUserStrategyManagerImpl
implements RequestAccessUserStrategyManager,
RequestAccessUserProviderRegistry {
    private final LinkedHashSet<RequestAccessUserStrategy> strategies = new LinkedHashSet();

    @Autowired
    public RequestAccessUserStrategyManagerImpl(ReporterRequestAccessUserStrategy reporterRequestAccessUserStrategy, RequestParticipantRequestAccessUserStrategy requestParticipantRequestAccessUserStrategy, CustomerOrganisationParticipantRequestAccessUserStrategy customerOrganisationParticipantRequestAccessUserStrategy, CustomerOutsiderRequestAccessUserStrategy customerOutsiderRequestAccessUserStrategy) {
        this.register(reporterRequestAccessUserStrategy);
        this.register(requestParticipantRequestAccessUserStrategy);
        this.register(customerOrganisationParticipantRequestAccessUserStrategy);
        this.register(customerOutsiderRequestAccessUserStrategy);
    }

    @Override
    public List<CheckedUser> getMembers(Issue issue) {
        return this.getMembersFromStrategyStream(issue, this.strategies.stream());
    }

    @Override
    public List<CheckedUser> getMembersForTypes(Issue issue, CustomerInvolvedType ... types) {
        return this.getMembersFromStrategyStream(issue, this.getStrategyStreamForTypes(types));
    }

    private Stream<RequestAccessUserStrategy> getStrategyStreamForTypes(CustomerInvolvedType[] types) {
        EnumSet<CustomerInvolvedType> typesSet = EnumSet.copyOf(Arrays.asList(types));
        return this.strategies.stream().filter(strategy -> typesSet.contains(strategy.getType()));
    }

    private List<CheckedUser> getMembersFromStrategyStream(Issue issue, Stream<RequestAccessUserStrategy> strategies) {
        List members = strategies.flatMap(strategy -> strategy.getUsers(issue).stream()).distinct().collect(Collectors.toList());
        return Collections.unmodifiableList(members);
    }

    @Override
    public boolean match(ApplicationUser user, Issue issue) {
        return this.strategies.stream().anyMatch(strategy -> strategy.match(user, issue));
    }

    @Override
    public boolean match(ApplicationUser user, Issue issue, CustomerInvolvedType ... type) {
        return this.getStrategyStreamForTypes(type).anyMatch(strategy -> strategy.match(user, issue));
    }

    public void register(RequestAccessUserStrategy strategy) {
        this.strategies.add(strategy);
    }

    public void unregister(RequestAccessUserStrategy strategy) {
        this.strategies.remove(strategy);
    }
}

