/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.permission.security;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.spi.permission.security.CustomerInvolvedType;
import com.atlassian.servicedesk.internal.spi.permission.security.RequestAccessUserStrategy;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReporterRequestAccessUserStrategy
implements RequestAccessUserStrategy {
    private final UserFactory userFactory;

    @Autowired
    public ReporterRequestAccessUserStrategy(UserFactory userFactory) {
        this.userFactory = userFactory;
    }

    public List<CheckedUser> getUsers(@Nonnull Issue issue) {
        if (issue.getReporterUser() == null) {
            return Collections.emptyList();
        }
        return (List)this.userFactory.wrap(issue.getReporterUser()).fold(error -> Collections.emptyList(), ImmutableList::of);
    }

    public CustomerInvolvedType getType() {
        return CustomerInvolvedType.REPORTER;
    }

    public boolean match(ApplicationUser user, Issue issue) {
        if (user == null || issue == null) {
            return false;
        }
        return user.getKey().equals(issue.getReporterId());
    }
}

