/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.permission.security;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.spi.permission.security.CustomerInvolvedType;
import com.atlassian.servicedesk.internal.spi.permission.security.RequestAccessUserStrategy;
import com.atlassian.servicedesk.internal.utils.context.ServiceDeskOutsideCustomerPermissionContext;
import io.atlassian.fugue.Suppliers;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerOutsiderRequestAccessUserStrategy
implements RequestAccessUserStrategy {
    private final ServiceDeskOutsideCustomerPermissionContext serviceDeskOutsideCustomerPermissionContext;
    private final UserFactory userFactory;

    @Autowired
    public CustomerOutsiderRequestAccessUserStrategy(ServiceDeskOutsideCustomerPermissionContext serviceDeskOutsideCustomerPermissionContext, UserFactory userFactory) {
        this.serviceDeskOutsideCustomerPermissionContext = serviceDeskOutsideCustomerPermissionContext;
        this.userFactory = userFactory;
    }

    public List<CheckedUser> getUsers(@Nonnull Issue issue) {
        return this.serviceDeskOutsideCustomerPermissionContext.getOutsideCustomerContext().stream().filter(context -> Objects.equals(context.getIssue(), issue)).map(ServiceDeskOutsideCustomerPermissionContext.OutsideCustomerIssuePermissionContext::getCheckedUser).collect(Collectors.toList());
    }

    public CustomerInvolvedType getType() {
        return CustomerInvolvedType.CUSTOMER_OUTSIDER;
    }

    public boolean match(ApplicationUser user, Issue issue) {
        return (Boolean)StepsConverters.newerEither((Either)this.userFactory.wrap(user)).map(checkedUser -> this.serviceDeskOutsideCustomerPermissionContext.isInIssueOutsideCustomerContext((CheckedUser)checkedUser, issue)).getOr(Suppliers.alwaysFalse());
    }
}

