/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.permission.security;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.feature.reqparticipants.organization.CustomerOrganizationParticipantManager;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.spi.permission.security.CustomerInvolvedType;
import com.atlassian.servicedesk.internal.spi.permission.security.RequestAccessUserStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerOrganisationParticipantRequestAccessUserStrategy
implements RequestAccessUserStrategy {
    private final CustomerOrganizationParticipantManager customerOrganizationParticipantManager;
    private final UserFactory userFactory;
    private final FeatureManager featureManager;

    @Autowired
    public CustomerOrganisationParticipantRequestAccessUserStrategy(CustomerOrganizationParticipantManager customerOrganizationParticipantManager, UserFactory userFactory, FeatureManager featureManager) {
        this.customerOrganizationParticipantManager = customerOrganizationParticipantManager;
        this.userFactory = userFactory;
        this.featureManager = featureManager;
    }

    public List<CheckedUser> getUsers(@Nonnull Issue issue) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Collections.emptyList();
        }
        Collection users = (Collection)this.customerOrganizationParticipantManager.getOrganizationMembersForIssue(issue).getOrElse(Collections.emptyList());
        return new ArrayList<CheckedUser>(users);
    }

    public CustomerInvolvedType getType() {
        return CustomerInvolvedType.CUSTOMER_ORGANISATION;
    }

    public boolean match(ApplicationUser user, Issue issue) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return false;
        }
        return this.userFactory.wrap(user).exists(checkedUser -> this.customerOrganizationParticipantManager.isMemberOfAnyOrganizationsInIssue((CheckedUser)checkedUser, issue));
    }
}

