/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.permission.misconfiguration;

import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.capability.Capability;
import com.atlassian.servicedesk.internal.capability.CapabilityService;
import com.atlassian.servicedesk.internal.permission.misconfiguration.MisconfigurationStatus;
import com.atlassian.servicedesk.internal.permission.misconfiguration.Severity;
import com.atlassian.servicedesk.internal.permission.misconfiguration.error.MisconfigurationInformation;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableBoolean;

public class MisconfigurationUtilities {
    private static final String DISMISS_WARNING_FOR_PERMISSION_PREFIX = "DISMISS_WARNING_FOR_PERMISSION_SCHEME_";
    private static final Comparator<MisconfigurationInformation> COMPARATOR = new Comparator<MisconfigurationInformation>(){

        @Override
        public int compare(MisconfigurationInformation lhs, MisconfigurationInformation rhs) {
            return Integer.compare(lhs.getSeverity().getPriority(), rhs.getSeverity().getPriority());
        }
    };
    private static final Function<Capability, String> VALUE_FROM_CAPABILITY_FUNCTION = Capability::getValue;
    private static final Predicate<String> PARSED_BOOLEAN_PREDICATE = Boolean::parseBoolean;
    private final CapabilityService capabilityService;

    public MisconfigurationUtilities(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public static String getDismissCapabilityName(MisconfigurationInformation error, ProjectPermissionKey projectPermissionKey, Option<Long> projectPermissionSchemeId) {
        return DISMISS_WARNING_FOR_PERMISSION_PREFIX + projectPermissionSchemeId.getOrNull() + "_" + error.getReasonKey() + "_" + projectPermissionKey.permissionKey();
    }

    public static boolean isCapabilityAMisconfiguration(Capability capability) {
        return StringUtils.startsWith((String)capability.getName(), (String)DISMISS_WARNING_FOR_PERMISSION_PREFIX);
    }

    public static boolean isCapabilityAMisconfigurationOfPermission(Capability capability, ProjectPermissionKey projectPermissionKey) {
        return MisconfigurationUtilities.isCapabilityAMisconfiguration(capability) && StringUtils.endsWith((String)capability.getName(), (String)projectPermissionKey.permissionKey());
    }

    public static boolean isCapabilityAMisconfigurationOfPermissionForScheme(Capability capability, ProjectPermissionKey projectPermissionKey, Option<Long> projectPermissionSchemeId) {
        return MisconfigurationUtilities.isCapabilityAMisconfigurationOfPermission(capability, projectPermissionKey) && StringUtils.startsWith((String)capability.getName(), (String)(DISMISS_WARNING_FOR_PERMISSION_PREFIX + projectPermissionSchemeId.getOrNull()));
    }

    public static boolean isCapabilityDismissed(Capability capability) {
        return MisconfigurationUtilities.isCapabilityAMisconfiguration(capability) && MisconfigurationUtilities.isCapabilityValueDismissed((Option<String>)Option.option((Object)capability.getValue()));
    }

    private static boolean isCapabilityValueDismissed(Option<String> capabilityValue) {
        return capabilityValue.exists(PARSED_BOOLEAN_PREDICATE);
    }

    private static boolean isNoCapabilityOrValueDismissed(Option<String> capabilityValue) {
        return capabilityValue.forall(PARSED_BOOLEAN_PREDICATE);
    }

    private static List<MisconfigurationInformation> sortErrors(Collection<MisconfigurationInformation> configErrors) {
        ArrayList copy = Lists.newArrayList(configErrors);
        Collections.sort(copy, COMPARATOR);
        return copy;
    }

    public Collection<Capability> resetDismissedCapabilitiesThatNoLongerUsed(CheckedUser user, ServiceDesk serviceDesk, Set<String> currentlyInUseDismissedCapabilities) {
        Option userKeyOpt = Option.option((Object)user.getKey());
        Collection filter2 = Collections2.filter(this.capabilityService.getCapabilities(serviceDesk), input -> {
            boolean reset2 = MisconfigurationUtilities.isCapabilityAMisconfiguration(input);
            reset2 &= !currentlyInUseDismissedCapabilities.contains(input.getName());
            reset2 &= MisconfigurationUtilities.isCapabilityDismissed(input);
            if (reset2 &= Objects.equals(input.getUserKey(), userKeyOpt)) {
                Either<ErrorCollection, Capability> eitherResult = this.capabilityService.setCapability(serviceDesk, input.getName(), input.getUserKey(), String.valueOf(false));
                Option value = eitherResult.right().toOption().map(VALUE_FROM_CAPABILITY_FUNCTION);
                return MisconfigurationUtilities.isNoCapabilityOrValueDismissed((Option<String>)value);
            }
            return false;
        });
        return Lists.newArrayList((Iterable)filter2);
    }

    public Option<MisconfigurationStatus> getMisconfigurationStatus(CheckedUser user, ServiceDesk serviceDesk, Option<Long> permissionSchemeId, List<MisconfigurationInformation> configurationErrors) {
        List<MisconfigurationInformation> sortedErrors = MisconfigurationUtilities.sortErrors(configurationErrors);
        Option first = Iterables.first(sortedErrors);
        return first.map(input -> {
            boolean dismissed;
            Severity highestSeverity = input.getSeverity();
            HashSet currentlyInUseDismissedCapabilities = Sets.newHashSet();
            if (highestSeverity.isCanBeDismissed()) {
                MutableBoolean hasBeenDismissed = new MutableBoolean(true);
                Option userKey = Option.option((Object)user.getKey());
                for (MisconfigurationInformation error : sortedErrors) {
                    for (ProjectPermissionKey key : error.getProjectPermissionKeys()) {
                        String capabilityName = MisconfigurationUtilities.getDismissCapabilityName(error, key, permissionSchemeId);
                        if (MisconfigurationUtilities.isCapabilityValueDismissed(this.capabilityService.getCapability(serviceDesk, capabilityName, (Option<String>)userKey))) {
                            currentlyInUseDismissedCapabilities.add(capabilityName);
                            continue;
                        }
                        hasBeenDismissed.setValue(false);
                    }
                }
                dismissed = hasBeenDismissed.booleanValue();
            } else {
                dismissed = false;
            }
            List errors = dismissed ? Collections.emptyList() : sortedErrors;
            return new MisconfigurationStatus(highestSeverity, errors, currentlyInUseDismissedCapabilities);
        });
    }
}

