/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.onboarding;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.onboarding.OnBoardingPropertiesService;
import com.google.common.collect.Lists;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class OnBoardingPropertiesServiceImpl
implements OnBoardingPropertiesService {
    private static String WELCOME_GUIDE_DISMISSED = "sd.onboarding.welcome.guide.dismissed";
    private static String CUSTOMER_PORTAL_HELP_BUBBLE_SHOWN = "local.serviceddesk.customer.portal.help.tip.shown";
    private static String ONBOARDING_CHECKLIST_USER_PROP = "sd-onboarding-checklist-completion";
    private static String KNOWLEDGE_BASE_PRIMARY_NAV_DISMISSED = "sd.onboarding.knowledge.base.primary.nav.dismissed";
    private final UserPropertyManager userPropertyManager;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final AnalyticsService analyticsService;

    @Autowired
    public OnBoardingPropertiesServiceImpl(UserPropertyManager userPropertyManager, ServiceDeskPermissionService serviceDeskPermissionService, AnalyticsService analyticsService) {
        this.userPropertyManager = userPropertyManager;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.analyticsService = analyticsService;
    }

    public Boolean isWelcomeGuideDismissed(@Nonnull ApplicationUser user) {
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        return propertySet.getBoolean(WELCOME_GUIDE_DISMISSED);
    }

    public void dismissWelcomeGuide(@Nonnull ApplicationUser user) {
        this.setWelcomeGuideDismissed(user, true);
    }

    public void restoreWelcomeGuide(@Nonnull ApplicationUser user) {
        this.setWelcomeGuideDismissed(user, false);
    }

    private void setWelcomeGuideDismissed(@Nonnull ApplicationUser user, Boolean dismissed) {
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        propertySet.setBoolean(WELCOME_GUIDE_DISMISSED, dismissed.booleanValue());
    }

    public boolean shouldExpandAdminAgentHelpBubble(@Nonnull String bubbleHasBeenExpandedKey, @Nonnull ApplicationUser user, @Nonnull ServiceDesk serviceDesk) {
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        if (((Boolean)this.serviceDeskPermissionService.isAdminAgent(user, serviceDesk).getOrElse((Object)false)).booleanValue()) {
            return !propertySet.getBoolean(bubbleHasBeenExpandedKey);
        }
        return false;
    }

    public void dismissAdminAgentHelpBubble(@Nonnull String bubbleHasBeenExpandedKey, @Nonnull ApplicationUser user, @Nonnull ServiceDesk serviceDesk) {
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        propertySet.setBoolean(bubbleHasBeenExpandedKey, true);
    }

    public List<String> getCompletedChecklistItems(@Nonnull ApplicationUser user) {
        String checklistJsonBlob = this.userPropertyManager.getPropertySet(user).getString(ONBOARDING_CHECKLIST_USER_PROP);
        return this.toJsonArray(checklistJsonBlob);
    }

    public Boolean isChecklistItemCompleted(@Nonnull ApplicationUser user, @Nonnull String itemName) {
        String checklistJsonBlob = this.userPropertyManager.getPropertySet(user).getString(ONBOARDING_CHECKLIST_USER_PROP);
        return this.toJsonArray(checklistJsonBlob).contains(itemName);
    }

    public void setChecklistItemCompleted(@Nonnull ApplicationUser user, @Nonnull String itemName) {
        String checklistJsonBlob = this.userPropertyManager.getPropertySet(user).getString(ONBOARDING_CHECKLIST_USER_PROP);
        List<String> checklistList = this.toJsonArray(checklistJsonBlob);
        if (!checklistList.contains(itemName)) {
            checklistList.add(itemName);
            this.userPropertyManager.getPropertySet(user).setString(ONBOARDING_CHECKLIST_USER_PROP, this.toJsonArrayString(checklistList));
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new WelcomeGuideChecklistItemCompletedEvent(itemName));
        }
    }

    public Boolean isKnowledgeBasePrimaryNavDismissed(@Nonnull ApplicationUser user) {
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        return propertySet.getBoolean(KNOWLEDGE_BASE_PRIMARY_NAV_DISMISSED);
    }

    public void dismissKnowledgeBasePrimaryNav(@Nonnull ApplicationUser user) {
        this.setKnowledgeBasePrimaryNavDismissed(user, true);
    }

    public void restoreKnowledgeBasePrimaryNav(@Nonnull ApplicationUser user) {
        this.setKnowledgeBasePrimaryNavDismissed(user, false);
    }

    private void setKnowledgeBasePrimaryNavDismissed(ApplicationUser user, boolean dismissed) {
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        propertySet.setBoolean(KNOWLEDGE_BASE_PRIMARY_NAV_DISMISSED, dismissed);
    }

    private List<String> toJsonArray(String jsonArrayString) {
        try {
            if (jsonArrayString == null) {
                return Lists.newArrayList();
            }
            JSONArray array = new JSONArray(jsonArrayString);
            ArrayList arrayList = Lists.newArrayList();
            for (int i = 0; i < array.length(); ++i) {
                arrayList.add(array.getString(i));
            }
            return arrayList;
        }
        catch (JSONException ex) {
            return Lists.newArrayList();
        }
    }

    private String toJsonArrayString(@Nonnull List<String> list) {
        JSONArray array = new JSONArray(list);
        return array.toString();
    }

    @EventName(value="servicedesk.welcome.guide.checklist.item.completed")
    private static class WelcomeGuideChecklistItemCompletedEvent
    extends AnalyticsEvent {
        private String itemName;

        public WelcomeGuideChecklistItemCompletedEvent(String itemName) {
            this.itemName = itemName;
        }

        public String getItemName() {
            return this.itemName;
        }
    }
}

