/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications.render;

import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.internal.api.util.SoyTemplateRenderer;
import com.atlassian.servicedesk.internal.notifications.TextBody;
import com.atlassian.servicedesk.internal.notifications.render.HtmlTemplateRenderer;
import com.atlassian.soy.renderer.SoyException;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Whitelist;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TextTemplateRenderer {
    private final Logger log = Logger.getLogger(HtmlTemplateRenderer.class);
    private final SoyTemplateRenderer soyTemplateRenderer;

    @Autowired
    TextTemplateRenderer(SoyTemplateRenderer soyTemplateRenderer) {
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    TextBody renderWithHtmlStripped(String template, Map<String, Object> params) {
        return new TextBody(this.templateTextFromParsedHtml(template, params));
    }

    String templateTextFromParsedHtml(String template, Map<String, Object> params) {
        return this.parseHtmlToText(this.renderBaseTextEmailBody(template, params));
    }

    ServiceDeskEmailBody render(String template, Map<String, Object> params) {
        return new TextBody(this.renderBaseTextEmailBody(template, params));
    }

    String renderBaseTextEmailBody(String template, Map<String, Object> params) {
        return this.renderTextTemplate(template, params);
    }

    @VisibleForTesting
    String stripHtmlTags(String html) {
        return Jsoup.clean((String)html, (String)"", (Whitelist)Whitelist.none(), (Document.OutputSettings)new Document.OutputSettings().prettyPrint(false));
    }

    String renderTemplate(String template, Map<String, Object> params) {
        try {
            return this.soyTemplateRenderer.render("com.atlassian.servicedesk:soy", template, params);
        }
        catch (SoyException e) {
            this.log.error((Object)String.format("Unable to render soy template: %s", template), (Throwable)e);
            return "";
        }
    }

    private String parseHtmlToText(String textContent) {
        return StringEscapeUtils.unescapeHtml((String)this.stripHtmlTags(textContent));
    }

    private String getTextTemplate(String template) {
        return String.format("%s_text", template);
    }

    private String renderTextTemplate(String template, Map<String, Object> params) {
        return this.renderTemplate(this.getTextTemplate(template), params);
    }
}

