/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications.render;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.internal.api.notifications.render.SDRendererUtils;
import com.atlassian.servicedesk.internal.api.notifications.render.css.EmailCssApplicator;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.HelpCenterBrandingManagerScala;
import com.atlassian.servicedesk.internal.feature.customer.user.SDUserPreferencesManager;
import com.atlassian.servicedesk.internal.notifications.HTMLBody;
import com.atlassian.servicedesk.internal.notifications.SDRendererInternalUtils;
import com.atlassian.servicedesk.internal.notifications.ServiceDeskEmailCssLoader;
import com.atlassian.servicedesk.internal.notifications.render.HtmlTemplateRenderer;
import com.atlassian.servicedesk.internal.notifications.render.TextTemplateRenderer;
import com.atlassian.servicedesk.plugins.coreui.internal.utils.HelpUrlHelper;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={SDRendererUtils.class})
public class SDRendererInternalUtilsImpl
implements SDRendererInternalUtils {
    private final String PORTAL_URI_SUFFIX = "servicedesk/customer/portal";
    private final HtmlTemplateRenderer htmlTemplateRenderer;
    private final TextTemplateRenderer textTemplateRenderer;
    private final HelpCenterBrandingManagerScala helpCenterBrandingManager;
    private final SDUserPreferencesManager sdUserPreferencesManager;
    private final ApplicationProperties applicationProperties;
    private final HelpUrlHelper helpUrlHelper;
    private final ServiceDeskEmailCssLoader serviceDeskEmailCssLoader;

    @Autowired
    public SDRendererInternalUtilsImpl(HelpCenterBrandingManagerScala helpCenterBrandingManager, SDUserPreferencesManager sdUserPreferencesManager, HtmlTemplateRenderer htmlTemplateRenderer, TextTemplateRenderer textTemplateRenderer, ApplicationProperties applicationProperties, HelpUrlHelper helpUrlHelper, ServiceDeskEmailCssLoader serviceDeskEmailCssLoader) {
        this.helpCenterBrandingManager = helpCenterBrandingManager;
        this.sdUserPreferencesManager = sdUserPreferencesManager;
        this.htmlTemplateRenderer = htmlTemplateRenderer;
        this.textTemplateRenderer = textTemplateRenderer;
        this.applicationProperties = applicationProperties;
        this.helpUrlHelper = helpUrlHelper;
        this.serviceDeskEmailCssLoader = serviceDeskEmailCssLoader;
    }

    public String getClientUrl() {
        return StringUtils.removeEnd((String)this.applicationProperties.getString("jira.baseurl"), (String)"/");
    }

    public ServiceDeskEmailBody renderEmailBodyAsUserPreferredFormat(CheckedUser user, String template, Option<Issue> issue, Map<String, Object> messageParams) {
        if (this.sdUserPreferencesManager.isHtmlPreferred(user)) {
            EmailCssApplicator defaultEmailCssApplicator = this.createServiceDeskDefaultApplicator();
            return this.htmlTemplateRenderer.renderWithTextPartAsParsedHtml(user, template, issue, messageParams, defaultEmailCssApplicator);
        }
        return this.textTemplateRenderer.renderWithHtmlStripped(template, messageParams);
    }

    public ServiceDeskEmailBody renderEmailBodyAsText(String template, Map<String, Object> textParams) {
        return this.textTemplateRenderer.render(template, textParams);
    }

    public ServiceDeskEmailBody renderEmailBodyAsHtml(CheckedUser recipient, String template, Option<Issue> issue, Map<String, Object> htmlParams, Map<String, Object> textParams, EmailCssApplicator emailCssApplicator) {
        return this.htmlTemplateRenderer.render(recipient, template, issue, htmlParams, textParams, emailCssApplicator);
    }

    public EmailCssApplicator createServiceDeskDefaultApplicator() {
        return html -> {
            if (StringUtils.isNotEmpty((String)html)) {
                return this.serviceDeskEmailCssLoader.applyStyles(html);
            }
            return "";
        };
    }

    public ImmutableMap.Builder<String, Object> commonParameters(CheckedUser user, Option<Portal> portalOpt) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"wacLink", (Object)this.getWacUrl()).put((Object)"clientURI", (Object)this.getClientUrl()).put((Object)"portalSuffix", (Object)"servicedesk/customer/portal").put((Object)"user", (Object)user).put((Object)"helpCenterName", (Object)this.helpCenterBrandingManager.getSharedPortalName()).put((Object)"beaconLink", (Object)this.beaconUri());
        portalOpt.forEach(portal -> builder.put((Object)"portal", portal));
        return builder;
    }

    public ServiceDeskEmailBody attachHelpCenterLogo(ServiceDeskEmailBody emailBody, String contentId) {
        if (emailBody instanceof HTMLBody) {
            return this.htmlTemplateRenderer.attachHelpCenterLogoToHTMLBody((HTMLBody)emailBody, contentId);
        }
        return emailBody;
    }

    @Override
    public ImmutableMap<String, Object> includeCommonParams(CheckedUser checkedUser, Option<Portal> portalOpt, Map<String, Object> params) {
        return this.commonParameters(checkedUser, portalOpt).putAll(params).build();
    }

    String renderTemplate(String template, Map<String, Object> textParams) {
        return this.textTemplateRenderer.renderTemplate(template, textParams);
    }

    String renderHtmlTemplateWithDefaultStyles(String template, Map<String, Object> htmlParams) {
        EmailCssApplicator defaultEmailCssApplicator = this.createServiceDeskDefaultApplicator();
        return this.htmlTemplateRenderer.renderHtmlTemplate(template, htmlParams, defaultEmailCssApplicator);
    }

    private String getWacUrl() {
        return this.helpUrlHelper.getStaticLinks().getUrl("wac.notifications").getUrl();
    }

    private String beaconUri() {
        UriBuilder base = UriBuilder.fromUri((String)this.getClientUrl());
        return base.path("rest").path("analytics").path("1.0").path("email").path("trackOpen").build(new Object[0]).toString();
    }
}

