/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications.render;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.util.runners.AuthenticationContextUtil;
import com.atlassian.servicedesk.api.ServiceDeskManager;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.notifications.render.NotificationIssueFooterRenderer;
import com.atlassian.servicedesk.internal.api.portal.PortalManager;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.HelpCenterBrandingManagerScala;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailPlatformChannelManager;
import com.atlassian.servicedesk.internal.feature.notificationsubscription.NotificationSubscriptionManager;
import com.atlassian.servicedesk.internal.notifications.render.SDRendererInternalUtilsImpl;
import com.atlassian.servicedesk.internal.notifications.render.UnsubscribeLinkHelperImpl;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@ParametersAreNonnullByDefault
public class NotificationIssueFooterRendererImpl
implements NotificationIssueFooterRenderer {
    private static final String PORTAL_URL = "portalURL";
    private static final String ISSUE = "issue";
    private static final String UNSUBSCRIBE_LINK = "unsubscribeLink";
    private static final String EMAIL_CHANNEL_SETUP = "isEmailChannelSetup";
    private static final String HTML_FOOTER_TEMPLATE = "ServiceDesk.Templates.Notifications.Custom.additionalInfo";
    private static final String TEXT_FOOTER_TEMPLATE = "ServiceDesk.Templates.Notifications.Custom.additionalInfoPlainText";
    private static final String DISPLAY_ISSUE_LINK = "displayIssueLink";
    private static final String PARTICIPANTS_TEXT = "participantList_text";
    private static final String SHARED_PORTAL_LOGO_ID = "sharedPortalLogoId";
    private final SDRendererInternalUtilsImpl sdRendererUtils;
    private final ServiceDeskManager serviceDeskManager;
    private final EmailPlatformChannelManager emailPlatformChannelManager;
    private final AuthenticationContextUtil authenticationContextUtil;
    private final UnsubscribeLinkHelperImpl unsubscribeLinkHelper;
    private final PortalManager portalManager;
    private final UserFactory userFactory;
    private final HelpCenterBrandingManagerScala helpCenterBrandingManager;
    private final NotificationSubscriptionManager notificationSubscriptionManager;

    @Autowired
    public NotificationIssueFooterRendererImpl(SDRendererInternalUtilsImpl sdRendererUtils, ServiceDeskManager serviceDeskManager, EmailPlatformChannelManager emailPlatformChannelManager, AuthenticationContextUtil authenticationContextUtil, UnsubscribeLinkHelperImpl unsubscribeLinkHelper, PortalManager portalManager, UserFactory userFactory, HelpCenterBrandingManagerScala helpCenterBrandingManager, NotificationSubscriptionManager notificationSubscriptionManager) {
        this.sdRendererUtils = sdRendererUtils;
        this.serviceDeskManager = serviceDeskManager;
        this.emailPlatformChannelManager = emailPlatformChannelManager;
        this.authenticationContextUtil = authenticationContextUtil;
        this.unsubscribeLinkHelper = unsubscribeLinkHelper;
        this.portalManager = portalManager;
        this.userFactory = userFactory;
        this.helpCenterBrandingManager = helpCenterBrandingManager;
        this.notificationSubscriptionManager = notificationSubscriptionManager;
    }

    public String renderHtmlIssueFooter(ApplicationUser recipient, String participants, Issue issue, String portalUrl, Project project) {
        return this.renderAsUser(recipient, () -> {
            Map<String, Object> params = this.retrieveIssueFooterParameters(recipient, participants, issue, portalUrl, project);
            return this.sdRendererUtils.renderHtmlTemplateWithDefaultStyles(HTML_FOOTER_TEMPLATE, params);
        });
    }

    public String renderPlainTextIssueFooter(ApplicationUser recipient, String participants, Issue issue, String portalUrl, Project project) {
        return this.renderAsUser(recipient, () -> {
            Map<String, Object> params = this.retrieveIssueFooterParameters(recipient, participants, issue, portalUrl, project);
            return this.sdRendererUtils.renderTemplate(TEXT_FOOTER_TEMPLATE, params);
        });
    }

    private String renderAsUser(ApplicationUser user, Callable<String> renderCallable) {
        return (String)this.authenticationContextUtil.runAs(user, renderCallable);
    }

    private Map<String, Object> retrieveIssueFooterParameters(ApplicationUser recipient, String participants, Issue issue, String portalUrl, Project project) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        List emailChannels = (List)this.serviceDeskManager.getServiceDeskForProject(project).map(this.emailPlatformChannelManager::getValidEmailChannelsByServiceDesk).getOrElse(Collections.emptyList());
        builder.put((Object)ISSUE, (Object)issue).put((Object)EMAIL_CHANNEL_SETUP, (Object)(!emailChannels.isEmpty() ? 1 : 0)).put((Object)PORTAL_URL, (Object)portalUrl).put((Object)DISPLAY_ISSUE_LINK, (Object)true).put((Object)PARTICIPANTS_TEXT, (Object)participants);
        this.helpCenterBrandingManager.getHelpCenterBranding().getLogoId().forEach(logId -> builder.put((Object)SHARED_PORTAL_LOGO_ID, (Object)"jsd-content-id-shared-portal-logo"));
        this.userFactory.wrap(recipient).foreach(checkedRecipient -> {
            builder.putAll(this.retrieveCommonParameters(project, (CheckedUser)checkedRecipient));
            this.getUnsubscribeLink(issue, (CheckedUser)checkedRecipient).forEach(unsubscribeLink -> builder.put((Object)UNSUBSCRIBE_LINK, unsubscribeLink));
        });
        return builder.build();
    }

    private Option<String> getUnsubscribeLink(Issue issue, CheckedUser checkedRecipient) {
        if (this.notificationSubscriptionManager.isSubscribed(checkedRecipient, issue)) {
            return this.unsubscribeLinkHelper.getUnsubscribeLink(issue, checkedRecipient.forJIRA());
        }
        return Option.none();
    }

    private Map<String, Object> retrieveCommonParameters(Project project, CheckedUser checkedRecipient) {
        return this.sdRendererUtils.commonParameters(checkedRecipient, (Option<Portal>)this.portalManager.getPortalByProject(project).toOption()).build();
    }
}

