/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications.render;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.util.runners.AuthenticationContextUtil;
import com.atlassian.servicedesk.internal.api.feedback.settings.FeedbackSettings;
import com.atlassian.servicedesk.internal.api.notifications.render.NotificationIssueCSATRenderer;
import com.atlassian.servicedesk.internal.api.util.SoyTemplateRenderer;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.notifications.render.SDRendererInternalUtilsImpl;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@ParametersAreNonnullByDefault
public class NotificationIssueCSATRendererImpl
implements NotificationIssueCSATRenderer {
    private static final String SD_PLUGIN_KEY = "com.atlassian.servicedesk";
    private static final String HTML_CSAT_TEMPLATE = "ServiceDesk.Templates.Feedback.ratingSection";
    private static final String TEXT_CSAT_TEMPLATE = "ServiceDesk.Templates.Feedback.ratingSection_text";
    private static final String STAR_ID = "starId";
    private static final String RATING_SCALE = "ratingScale";
    private static final String FEEDBACK_URL = "feedbackURL";
    private static final String FEEDBACK_QUESTION = "feedbackQuestion";
    private final SDRendererInternalUtilsImpl sdRendererUtils;
    private final AuthenticationContextUtil authenticationContextUtil;
    private final FeatureManager featureManager;
    private final SoyTemplateRenderer soyTemplateRenderer;

    @Autowired
    public NotificationIssueCSATRendererImpl(SDRendererInternalUtilsImpl sdRendererUtils, AuthenticationContextUtil authenticationContextUtil, FeatureManager featureManager, SoyTemplateRenderer soyTemplateRenderer) {
        this.sdRendererUtils = sdRendererUtils;
        this.authenticationContextUtil = authenticationContextUtil;
        this.featureManager = featureManager;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    public String getTextCSAT(ApplicationUser recipient, FeedbackSettings feedbackSettings, String feedbackUrl) {
        return this.renderAsUser(recipient, () -> {
            Map<String, Object> parameters = this.buildParameters(feedbackSettings, feedbackUrl);
            return this.sdRendererUtils.renderTemplate(TEXT_CSAT_TEMPLATE, parameters);
        });
    }

    public String getHtmlCSAT(ApplicationUser recipient, FeedbackSettings feedbackSettings, String feedbackUrl) {
        return this.renderAsUser(recipient, () -> {
            Map<String, Object> parameters = this.buildParameters(feedbackSettings, feedbackUrl);
            if (this.featureManager.isEnabled(SDFeatureFlags.NOTIFICATION_STYLING)) {
                return this.soyTemplateRenderer.render("com.atlassian.servicedesk:soy", HTML_CSAT_TEMPLATE, parameters);
            }
            return this.sdRendererUtils.renderHtmlTemplateWithDefaultStyles(HTML_CSAT_TEMPLATE, parameters);
        });
    }

    private String renderAsUser(ApplicationUser user, Callable<String> renderCallable) {
        return (String)this.authenticationContextUtil.runAs(user, renderCallable);
    }

    private Map<String, Object> buildParameters(FeedbackSettings feedbackSettings, String feedbackUrl) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        return builder.put((Object)STAR_ID, (Object)"jsd-content-id-star-logo").put((Object)RATING_SCALE, (Object)feedbackSettings.getScale()).put((Object)FEEDBACK_URL, (Object)feedbackUrl).put((Object)FEEDBACK_QUESTION, (Object)feedbackSettings.getQuestion()).build();
    }
}

