/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications.render;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mail.MailImageInliner;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.internal.api.notifications.render.css.EmailCssApplicator;
import com.atlassian.servicedesk.internal.api.request.CustomerTextRenderer;
import com.atlassian.servicedesk.internal.api.util.SoyTemplateRenderer;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.HelpCenterBranding;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.HelpCenterBrandingManagerScala;
import com.atlassian.servicedesk.internal.images.ImageFileQStore;
import com.atlassian.servicedesk.internal.notifications.HTMLBody;
import com.atlassian.servicedesk.internal.notifications.render.TextTemplateRenderer;
import com.atlassian.servicedesk.squalor.email.ServiceDeskMailUtils;
import com.atlassian.soy.renderer.SoyException;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.internet.MimeBodyPart;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class HtmlTemplateRenderer {
    private final Logger log = Logger.getLogger(HtmlTemplateRenderer.class);
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final MailImageInliner mailImageInliner;
    private final ImageFileQStore imageFileQStore;
    private final HelpCenterBrandingManagerScala helpCenterBrandingManager;
    private final TextTemplateRenderer textTemplateRenderer;
    private final CustomerTextRenderer customerTextRenderer;

    @Autowired
    HtmlTemplateRenderer(SoyTemplateRenderer soyTemplateRenderer, MailImageInliner mailImageInliner, ImageFileQStore imageFileQStore, HelpCenterBrandingManagerScala helpCenterBrandingManager, TextTemplateRenderer textTemplateRenderer, CustomerTextRenderer customerTextRenderer) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.mailImageInliner = mailImageInliner;
        this.imageFileQStore = imageFileQStore;
        this.helpCenterBrandingManager = helpCenterBrandingManager;
        this.textTemplateRenderer = textTemplateRenderer;
        this.customerTextRenderer = customerTextRenderer;
    }

    public HTMLBody render(CheckedUser recipient, String template, Option<Issue> issueOpt, Map<String, Object> htmlParams, Map<String, Object> textParams, EmailCssApplicator emailCssApplicator) {
        String htmlContent = this.renderHtmlTemplate(template, htmlParams, emailCssApplicator);
        String textContent = this.textTemplateRenderer.renderBaseTextEmailBody(template, textParams);
        return this.buildMultiPartHtmlEmailBody(recipient, issueOpt, htmlContent, textContent);
    }

    HTMLBody renderWithTextPartAsParsedHtml(CheckedUser recipient, String template, Option<Issue> issueOpt, Map<String, Object> params, EmailCssApplicator emailCssApplicator) {
        String htmlContent = this.renderHtmlTemplate(template, params, emailCssApplicator);
        String textContent = this.textTemplateRenderer.templateTextFromParsedHtml(template, params);
        return this.buildMultiPartHtmlEmailBody(recipient, issueOpt, htmlContent, textContent);
    }

    ServiceDeskEmailBody attachHelpCenterLogoToHTMLBody(HTMLBody htmlBody, String contentId) {
        HelpCenterBranding helpCenterBranding = this.helpCenterBrandingManager.getHelpCenterBranding();
        return (ServiceDeskEmailBody)Steps.begin(helpCenterBranding.getLogoId()).then(this.imageFileQStore::getImageById).yield((logoId, logoStream) -> this.addLogoPNGAsBodyPart(htmlBody, contentId, (InputStream)logoStream)).getOrElse((Object)htmlBody);
    }

    String renderHtmlTemplate(String template, Map<String, Object> params, EmailCssApplicator emailCssApplicator) {
        String renderedContent = this.renderTemplate(template, params);
        return emailCssApplicator.applyCss(renderedContent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HTMLBody addLogoPNGAsBodyPart(HTMLBody htmlBody, String id, InputStream logoStream) {
        try (InputStream stream = logoStream;){
            MimeBodyPart logoBodyPart = ServiceDeskMailUtils.getInlinePNGImagePart((String)id, (InputStream)stream);
            ImmutableList bodyParts = ImmutableList.builder().addAll(htmlBody.getBodyParts()).add((Object)logoBodyPart).build();
            HTMLBody hTMLBody = new HTMLBody(htmlBody.getBody(), htmlBody.getTextOpt(), (List<BodyPart>)bodyParts);
            return hTMLBody;
        }
        catch (IOException e) {
            this.log.error((Object)"Exception raised while adding the logo image as a message part", (Throwable)e);
            return htmlBody;
        }
    }

    private HTMLBody buildMultiPartHtmlEmailBody(CheckedUser recipient, Option<Issue> issueOpt, String htmlContent, String textContent) {
        MailImageInliner.InlinedEmailBody inlinedEmailBody = this.inlineHtml(htmlContent, issueOpt);
        Option issueIdOpt = issueOpt.map(Issue::getId);
        String html = this.customerTextRenderer.updateEmailTextForCustomer(inlinedEmailBody.getHtml(), Option.some((Object)recipient), issueIdOpt);
        return new HTMLBody(html, (Option<String>)Option.some((Object)textContent), (List<BodyPart>)ImmutableList.copyOf((Iterable)inlinedEmailBody.getBodyParts()));
    }

    private MailImageInliner.InlinedEmailBody inlineHtml(String html, Option<Issue> issueOpt) {
        return (MailImageInliner.InlinedEmailBody)issueOpt.fold(() -> this.mailImageInliner.inlineImages(html), issue -> this.mailImageInliner.inlineImages(html, issue));
    }

    private String renderTemplate(String template, Map<String, Object> params) {
        try {
            return this.soyTemplateRenderer.render("com.atlassian.servicedesk:soy", template, params);
        }
        catch (SoyException e) {
            this.log.error((Object)String.format("Unable to render soy template: %s", template), (Throwable)e);
            return "";
        }
    }
}

