/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications.model;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmail;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBuilderFactory;
import com.atlassian.servicedesk.internal.notifications.HTMLBody;
import com.atlassian.servicedesk.internal.notifications.TextBody;
import com.atlassian.servicedesk.internal.notifications.model.ServiceDeskEmailImpl;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.mail.BodyPart;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ServiceDeskEmailBuilderFactoryImpl
implements ServiceDeskEmailBuilderFactory {
    public ServiceDeskEmail.Builder newBuilder() {
        return new ServiceDeskEmailBuilderImpl();
    }

    private static class ProjectContext {
        private final Option<Project> projectOpt;

        private ProjectContext(Option<Project> projectOpt) {
            this.projectOpt = projectOpt;
        }
    }

    private class ServiceDeskEmailBuilderImpl
    implements ServiceDeskEmail.Builder {
        private Option<String> toAddress = Option.none();
        private Option<String> fromAddress = Option.none();
        private Option<String> fromNameOpt = Option.none();
        private Option<String> subject = Option.none();
        private Option<ServiceDeskEmailBody> emailBody = Option.none();
        private Option<ProjectContext> projectContextOpt = Option.none();
        private Option<Issue> issueOpt = Option.none();
        private Option<String> replyToHeaderOpt = Option.none();
        private boolean includeMailServerSubjectPrefix = true;

        private ServiceDeskEmailBuilderImpl() {
        }

        public ServiceDeskEmail.Builder subject(String subject) {
            this.subject = Option.option((Object)subject);
            return this;
        }

        public ServiceDeskEmail.Builder toAddress(String toAddress) {
            this.toAddress = Option.option((Object)toAddress);
            return this;
        }

        public ServiceDeskEmail.Builder textEmailBody(String body) {
            this.emailBody = Option.option((Object)body).map(TextBody::new);
            return this;
        }

        public ServiceDeskEmail.Builder htmlEmailBody(String bodyHtml, Option<String> bodyAsTextOpt, List<BodyPart> bodyParts) {
            this.emailBody = Option.option((Object)bodyHtml).map(nonNullBodyHtml -> new HTMLBody((String)nonNullBodyHtml, bodyAsTextOpt, bodyParts));
            return this;
        }

        public ServiceDeskEmail.Builder serviceDeskEmailBody(ServiceDeskEmailBody serviceDeskEmailBody) {
            this.emailBody = Option.option((Object)serviceDeskEmailBody);
            return this;
        }

        public ServiceDeskEmail.Builder fromAddress(String fromAddress) {
            this.fromAddress = Option.option((Object)fromAddress);
            return this;
        }

        public ServiceDeskEmail.Builder fromName(String fromName) {
            this.fromNameOpt = Option.option((Object)fromName);
            return this;
        }

        public ServiceDeskEmail.Builder projectContext(Option<Project> projectOpt) {
            Option nullCheckedProjectOption = (Option)Option.option(projectOpt).getOrElse((Object)Option.none());
            this.projectContextOpt = Option.some((Object)new ProjectContext(nullCheckedProjectOption));
            return this;
        }

        public ServiceDeskEmail.Builder issue(Issue issue) {
            this.issueOpt = Option.option((Object)issue);
            this.projectContext((Option<Project>)this.issueOpt.map(Issue::getProjectObject));
            return this;
        }

        public ServiceDeskEmail.Builder replyToHeader(String replyToHeader) {
            this.replyToHeaderOpt = Option.option((Object)replyToHeader);
            return this;
        }

        public ServiceDeskEmail.Builder includeMailServerSubjectPrefix(boolean includeMailServerSubjectPrefix) {
            this.includeMailServerSubjectPrefix = includeMailServerSubjectPrefix;
            return this;
        }

        public ServiceDeskEmail build() {
            this.validate();
            return new ServiceDeskEmailImpl((String)this.toAddress.getOrNull(), this.fromAddress, this.fromNameOpt, (String)this.subject.getOrNull(), (ServiceDeskEmailBody)this.emailBody.getOrNull(), (Option<Project>)((ProjectContext)this.projectContextOpt.get()).projectOpt, this.issueOpt, this.replyToHeaderOpt, this.includeMailServerSubjectPrefix);
        }

        private void validate() {
            Preconditions.checkState((boolean)this.subject.isDefined(), (Object)"An email subject is required");
            Preconditions.checkState((boolean)this.toAddress.isDefined(), (Object)"An email to address is required");
            Preconditions.checkState((boolean)this.emailBody.isDefined(), (Object)"An email body is required");
            Preconditions.checkState((boolean)this.projectContextOpt.isDefined(), (Object)"An email project context is required");
        }
    }
}

