/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications.model;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.AbstractMailQueueItem;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import io.atlassian.fugue.Option;

public class ServiceDeskDeferredMailQueueItem
extends AbstractMailQueueItem {
    private final Option<CheckedUser> executingUser;
    private final boolean wasInCustomerContext;
    private final Runnable buildAndSendNotificationsCallback;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final I18nHelper siteLocaleI18nHelper;
    private final SafeRunner safeRunner;
    private final CustomerContextService customerContextService;

    public ServiceDeskDeferredMailQueueItem(Option<CheckedUser> executingUser, Runnable buildAndSendNotificationsCallback, boolean wasInCustomerContext, JiraAuthenticationContext jiraAuthenticationContext, I18nHelper siteLocaleI18nHelper, SafeRunner safeRunner, CustomerContextService customerContextService) {
        this.buildAndSendNotificationsCallback = buildAndSendNotificationsCallback;
        this.executingUser = executingUser;
        this.wasInCustomerContext = wasInCustomerContext;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.siteLocaleI18nHelper = siteLocaleI18nHelper;
        this.safeRunner = safeRunner;
        this.customerContextService = customerContextService;
    }

    public void send() throws MailException {
        this.incrementSendCount();
        this.safeRunner.run(() -> {
            ApplicationUser userBeforeExecution = this.jiraAuthenticationContext.getLoggedInUser();
            try {
                if (this.executingUser.isDefined()) {
                    this.jiraAuthenticationContext.setLoggedInUser(((CheckedUser)this.executingUser.get()).forJIRA());
                }
                if (this.wasInCustomerContext) {
                    this.customerContextService.inCustomerContext(this.buildAndSendNotificationsCallback);
                } else {
                    this.customerContextService.outOfCustomerContext(this.buildAndSendNotificationsCallback);
                }
            }
            finally {
                this.jiraAuthenticationContext.setLoggedInUser(userBeforeExecution);
            }
        });
    }

    public String getSubject() {
        return this.siteLocaleI18nHelper.getText("sd.notification.deferred.renderer.subject");
    }
}

