/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mail.JiraMailThreader;
import com.atlassian.jira.mail.settings.MailSettings;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailThreader;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.notifications.GlobalNotificationsManager;
import com.atlassian.servicedesk.internal.api.notifications.ServiceDeskNotificationSender;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmail;
import com.atlassian.servicedesk.internal.notifications.ServiceDeskNotificationInternalSender;
import com.atlassian.servicedesk.internal.notifications.model.ServiceDeskDeferredMailQueueItem;
import com.atlassian.servicedesk.internal.notifications.render.SDUserNotificationRenderer;
import com.atlassian.servicedesk.internal.notifications.render.ServiceDeskTestEmail;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import io.atlassian.fugue.Option;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={ServiceDeskNotificationInternalSender.class, ServiceDeskNotificationSender.class})
class ServiceDeskNotificationInternalSenderImpl
implements ServiceDeskNotificationInternalSender {
    private static final Logger log = Logger.getLogger(ServiceDeskNotificationInternalSenderImpl.class);
    private final SafeRunner safeRunner;
    private final MailQueue mailQueue;
    private final MailServerManager mailServerManager;
    private final MailSettings mailSettings;
    private final SDUserNotificationRenderer serviceDeskEmailRenderer;
    private final JiraProperties jiraProperties;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory i18nHelperBeanFactory;
    private final GlobalNotificationsManager globalNotificationsManager;
    private final CustomerContextService customerContextService;

    @Autowired
    public ServiceDeskNotificationInternalSenderImpl(SafeRunner safeRunner, MailQueue mailQueue, MailServerManager mailServerManager, MailSettings mailSettings, SDUserNotificationRenderer serviceDeskEmailRenderer, JiraProperties jiraProperties, JiraAuthenticationContext jiraAuthenticationContext, ApplicationProperties applicationProperties, I18nHelper.BeanFactory i18nHelperBeanFactory, GlobalNotificationsManager globalNotificationsManager, CustomerContextService customerContextService) {
        this.safeRunner = safeRunner;
        this.mailQueue = mailQueue;
        this.mailServerManager = mailServerManager;
        this.mailSettings = mailSettings;
        this.serviceDeskEmailRenderer = serviceDeskEmailRenderer;
        this.jiraProperties = jiraProperties;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.applicationProperties = applicationProperties;
        this.i18nHelperBeanFactory = i18nHelperBeanFactory;
        this.globalNotificationsManager = globalNotificationsManager;
        this.customerContextService = customerContextService;
    }

    public boolean isOutgoingMailConfigured() {
        return this.mailServerManager.isDefaultSMTPMailServerDefined() && this.mailSettings.send().isEnabled();
    }

    public boolean isServiceDeskNotificationEnabled() {
        return !this.globalNotificationsManager.isNotificationDisabled();
    }

    public void send(ServiceDeskEmail serviceDeskEmail) {
        this.safeRunner.run(() -> this.sendSDEmail(serviceDeskEmail));
    }

    @Override
    public void sendTestEmail(CheckedUser user, String emailAddress, boolean isEdit, Project project) {
        if (this.isOutgoingMailConfigured()) {
            this.safeRunner.run(() -> {
                ServiceDeskTestEmail serviceDeskEmail = this.serviceDeskEmailRenderer.createTestEmail(user, emailAddress, isEdit, project);
                this.sendSDEmail(serviceDeskEmail);
            });
        }
    }

    @Override
    public void enqueueDeferredNotificationTask(CheckedUser executingUser, Runnable buildAndSendCallback) {
        I18nHelper siteLocaleI18nHelper = this.i18nHelperBeanFactory.getInstance(this.applicationProperties.getDefaultLocale());
        boolean wasInCustomerContext = this.customerContextService.isInCustomerContext();
        ServiceDeskDeferredMailQueueItem deferredMailQueueItem = new ServiceDeskDeferredMailQueueItem((Option<CheckedUser>)Option.option((Object)executingUser), buildAndSendCallback, wasInCustomerContext, this.jiraAuthenticationContext, siteLocaleI18nHelper, this.safeRunner, this.customerContextService);
        this.mailQueue.addItem((MailQueueItem)deferredMailQueueItem);
    }

    private void sendSDEmail(ServiceDeskEmail serviceDeskEmail) {
        com.atlassian.jira.mail.Email email = serviceDeskEmail.buildEmail();
        Option issueOption = serviceDeskEmail.getIssue();
        this.writeEmailWhenInDevMode(email);
        SingleMailQueueItem mqi = new SingleMailQueueItem((Email)email);
        if (issueOption.isDefined()) {
            Issue issue = (Issue)issueOption.getOrNull();
            mqi.setMailThreader((MailThreader)new JiraMailThreader(issue));
        }
        this.mailQueue.addItem((MailQueueItem)mqi);
    }

    private void writeEmailWhenInDevMode(com.atlassian.jira.mail.Email email) {
        if (this.jiraProperties.isDevMode()) {
            try {
                File f = new File("sd-customerview-notification.html");
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f)));
                w.write(email.getBody());
                ((Writer)w).close();
                log.warn((Object)("Email written to " + f.getAbsolutePath()));
            }
            catch (IOException e) {
                log.warn((Object)String.format("Unable to store email for debug purposes: %s", e.getMessage()));
            }
        }
    }
}

