/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.logging.LoggingSupport;
import com.atlassian.pocketknife.api.util.runners.AuthenticationContextUtil;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.analytics.ServiceDeskAnalyticsSourceService;
import com.atlassian.servicedesk.internal.api.analytics.emailevents.SDEmailAnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.feedbackevents.FeedbackAnalyticEvent;
import com.atlassian.servicedesk.internal.api.feedback.RequestFeedbackTokenManager;
import com.atlassian.servicedesk.internal.api.feedback.ValidatedFeedbackToken;
import com.atlassian.servicedesk.internal.api.feedback.settings.FeedbackSettings;
import com.atlassian.servicedesk.internal.api.notifications.FeedbackAttachmentManager;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmail;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBuilderFactory;
import com.atlassian.servicedesk.internal.api.notifications.render.SDRendererUtils;
import com.atlassian.servicedesk.internal.api.notifications.render.UnsubscribeLinkHelper;
import com.atlassian.servicedesk.internal.api.project.PortalUrlsProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.HelpCenterBrandingManagerScala;
import com.atlassian.servicedesk.internal.feature.customer.request.CustomerTextInternalRenderer;
import com.atlassian.servicedesk.internal.feature.emailchannel.EmailChannelScala;
import com.atlassian.servicedesk.internal.feature.emailchannel.emailplatform.EmailPlatformChannelManager;
import com.atlassian.servicedesk.internal.feature.feedback.settings.FeedbackSettingsInternalManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.field.RequestParticipantsInternalService;
import com.atlassian.servicedesk.internal.notifications.IssueConversationalNotificationRenderer;
import com.atlassian.servicedesk.internal.notifications.NotificationMessageContextInternalUtils;
import com.atlassian.servicedesk.internal.notifications.render.ServiceDeskNotificationContentUtilsScala;
import com.atlassian.servicedesk.internal.rest.responses.CustomerRequestView;
import com.atlassian.servicedesk.squalor.email.ServiceDeskMailUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueConversationalNotificationRendererImpl
implements IssueConversationalNotificationRenderer {
    static final String PORTAL_URL = "portalURL";
    private static final String ISSUE = "issue";
    private static final String MARKER_ENABLED = "isMarkerInsertionEnabled";
    private static final String EMAIL_CHANNEL_SETUP = "isEmailChannelSetup";
    private static final String COMMENT_TEXT = "commentText";
    private static final String COMMENT_HTML = "commentHtml";
    private static final String UNSUBSCRIBE_LINK = "unsubscribeLink";
    private static final String RESOLVER = "resolver";
    private static final String PARTICIPANT_INVITED_BY = "invitedBy";
    private static final String PARTICIPANTS_TEXT = "participantList_text";
    private static final String SHARED_PORTAL_LOGO_ID = "sharedPortalLogoId";
    private static final String STAR_ID = "starId";
    private static final String RATING_SCALE = "ratingScale";
    private static final String FEEDBACK_URL = "feedbackURL";
    private static final String FEEDBACK_QUESTION = "feedbackQuestion";
    private static final String EMAIL_TRACKING_EVENT_NAME = "emailTrackingEventName";
    private static final int PARTICIPANT_LIMIT = 3;
    private static final String ONE_PARTICIPANT_WITH_CREATOR = "sd.email.conversational.notification.one.participant.with.creator";
    private static final String THREE_PARTICIPANTS_WITH_CREATOR = "sd.email.conversational.notification.three.participants.with.creator";
    private static final String MORE_PARTICIPANTS_WITH_CREATOR = "sd.email.conversational.notification.more.participants.with.creator";
    private static final String ONE_PARTICIPANT_NO_CREATOR = "sd.email.conversational.notification.one.participant.no.creator";
    private static final String THREE_PARTICIPANTS_NO_CREATOR = "sd.email.conversational.notification.three.participants.no.creator";
    private static final String MORE_PARTICIPANTS_NO_CREATOR = "sd.email.conversational.notification.more.participants.no.creator";
    private final LoggingSupport loggingSupport;
    private final SDRendererUtils rendererUtils;
    private final I18nHelper i18nHelper;
    private final AnalyticsService analyticsService;
    private final EmailPlatformChannelManager emailPlatformManager;
    private final RequestParticipantsInternalService requestParticipantsService;
    private final ServiceDeskNotificationContentUtilsScala serviceDeskNotificationContentUtils;
    private final ServiceDeskAnalyticsSourceService serviceDeskAnalyticsSourceService;
    private final CustomerTextInternalRenderer customerTextRenderer;
    private final HelpCenterBrandingManagerScala helpCenterBrandingManager;
    private final FeedbackSettingsInternalManager feedbackSettingsService;
    private final RequestFeedbackTokenManager tokenManager;
    private final ServiceDeskEmailBuilderFactory serviceDeskEmailBuilderFactory;
    private final AuthenticationContextUtil authenticationContextUtil;
    private final NotificationMessageContextInternalUtils notificationMessageContextUtils;
    private final PortalUrlsProvider portalUrlsProvider;
    private final FeedbackAttachmentManager feedbackAttachmentManager;
    private final UnsubscribeLinkHelper unsubscribeLinkHelper;

    @Autowired
    public IssueConversationalNotificationRendererImpl(LoggingSupport loggingSupport, SDRendererUtils rendererUtils, I18nHelper i18nHelper, AnalyticsService analyticsService, EmailPlatformChannelManager emailPlatformManager, RequestParticipantsInternalService requestParticipantsService, ServiceDeskAnalyticsSourceService serviceDeskAnalyticsSourceService, ServiceDeskNotificationContentUtilsScala serviceDeskNotificationContentUtils, CustomerTextInternalRenderer customerTextRenderer, HelpCenterBrandingManagerScala helpCenterBrandingManager, FeedbackSettingsInternalManager feedbackSettingsService, RequestFeedbackTokenManager tokenManager, ServiceDeskEmailBuilderFactory serviceDeskEmailBuilderFactory, AuthenticationContextUtil authenticationContextUtil, NotificationMessageContextInternalUtils notificationMessageContextUtils, PortalUrlsProvider portalUrlsProvider, FeedbackAttachmentManager feedbackAttachmentManager, UnsubscribeLinkHelper unsubscribeLinkHelper) {
        this.loggingSupport = loggingSupport;
        this.rendererUtils = rendererUtils;
        this.i18nHelper = i18nHelper;
        this.analyticsService = analyticsService;
        this.emailPlatformManager = emailPlatformManager;
        this.requestParticipantsService = requestParticipantsService;
        this.serviceDeskAnalyticsSourceService = serviceDeskAnalyticsSourceService;
        this.serviceDeskNotificationContentUtils = serviceDeskNotificationContentUtils;
        this.customerTextRenderer = customerTextRenderer;
        this.helpCenterBrandingManager = helpCenterBrandingManager;
        this.feedbackSettingsService = feedbackSettingsService;
        this.tokenManager = tokenManager;
        this.serviceDeskEmailBuilderFactory = serviceDeskEmailBuilderFactory;
        this.authenticationContextUtil = authenticationContextUtil;
        this.notificationMessageContextUtils = notificationMessageContextUtils;
        this.portalUrlsProvider = portalUrlsProvider;
        this.feedbackAttachmentManager = feedbackAttachmentManager;
        this.unsubscribeLinkHelper = unsubscribeLinkHelper;
    }

    @Override
    public Option<ServiceDeskEmail> createIssueCreatedNotification(CheckedUser reporter, String senderName, Issue issue, Portal portal, ServiceDesk serviceDesk, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        return (Option)this.authenticationContextUtil.runAs(reporter.forJIRA(), () -> {
            Option<CustomerRequestView> customerRequestViewOption = this.serviceDeskNotificationContentUtils.getCustomerRequestView(reporter, issue, portal);
            return customerRequestViewOption.flatMap(customerRequestView -> {
                String subject = this.createIssueCreatedSubject(issue);
                String logoId = ServiceDeskMailUtils.generateServiceDeskEmailContentId();
                ImmutableMap.Builder<String, Object> contentParams = this.includeIssueCommonParams(reporter, issue, portal, serviceDesk, (CustomerRequestView)customerRequestView, logoId, emailAnalyticsEvent);
                ServiceDeskEmailBody serviceDeskEmailBody = this.rendererUtils.renderEmailBodyAsUserPreferredFormat(reporter, "ServiceDesk.Templates.Conversational.onIssueCreated", Option.option((Object)issue), (Map)contentParams.build());
                serviceDeskEmailBody = this.rendererUtils.attachHelpCenterLogo(serviceDeskEmailBody, logoId);
                return this.buildServiceDeskEmail(reporter, subject, serviceDeskEmailBody, portal.getName(), issue, serviceDesk);
            });
        });
    }

    @Override
    public Option<ServiceDeskEmail> createIssueCommentedNotification(CheckedUser recipient, String senderName, Issue issue, Comment comment, Portal portal, ServiceDesk serviceDesk, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        return (Option)this.authenticationContextUtil.runAs(recipient.forJIRA(), () -> {
            Option<CustomerRequestView> customerRequestViewOption = this.serviceDeskNotificationContentUtils.getCustomerRequestView(recipient, issue, portal);
            return customerRequestViewOption.flatMap(customerRequestView -> {
                String subject = this.createIssueCommentedSubject(issue);
                String logoId = ServiceDeskMailUtils.generateServiceDeskEmailContentId();
                ImmutableMap.Builder<String, Object> contentParams = this.includeIssueCommonParams(recipient, issue, portal, serviceDesk, (CustomerRequestView)customerRequestView, logoId, emailAnalyticsEvent);
                this.extractComment(contentParams, comment);
                ServiceDeskEmailBody serviceDeskEmailBody = this.rendererUtils.renderEmailBodyAsUserPreferredFormat(recipient, "ServiceDesk.Templates.Conversational.onIssueCommented", Option.option((Object)issue), (Map)contentParams.build());
                serviceDeskEmailBody = this.rendererUtils.attachHelpCenterLogo(serviceDeskEmailBody, logoId);
                return this.buildServiceDeskEmail(recipient, subject, serviceDeskEmailBody, senderName, issue, serviceDesk);
            });
        });
    }

    @Override
    public Option<ServiceDeskEmail> createIssueResolvedNotification(CheckedUser recipient, String senderName, Issue issue, Portal portal, ServiceDesk serviceDesk, Option<Comment> commentOpt, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        return (Option)this.authenticationContextUtil.runAs(recipient.forJIRA(), () -> {
            Option<CustomerRequestView> customerRequestViewOption = this.serviceDeskNotificationContentUtils.getCustomerRequestView(recipient, issue, portal);
            return customerRequestViewOption.flatMap(customerRequestView -> {
                boolean isReporter;
                String subject = this.createIssueResolvedSubject(issue, customerRequestView.getResolution());
                String logoId = ServiceDeskMailUtils.generateServiceDeskEmailContentId();
                ImmutableMap.Builder<String, Object> contentParams = this.includeIssueCommonParams(recipient, issue, portal, serviceDesk, (CustomerRequestView)customerRequestView, logoId, emailAnalyticsEvent);
                contentParams.put((Object)RESOLVER, (Object)senderName);
                String starId = null;
                ApplicationUser reporter = issue.getReporterUser();
                boolean bl = isReporter = reporter != null && recipient.getKey().equals(reporter.getKey());
                if (isReporter) {
                    FeedbackSettings feedbackSettings = this.feedbackSettingsService.getFeedbackSettings(serviceDesk);
                    Option<String> tokenOpt = this.generateToken(reporter, issue);
                    if (feedbackSettings.isEnabled() && tokenOpt.isDefined()) {
                        starId = "jsd-content-id-star-logo";
                        contentParams.put((Object)STAR_ID, (Object)starId);
                        contentParams.put((Object)RATING_SCALE, (Object)5);
                        contentParams.put((Object)FEEDBACK_QUESTION, (Object)feedbackSettings.getQuestion());
                        contentParams.put((Object)FEEDBACK_URL, (Object)this.getFeedbackUrl(portal, issue, (String)tokenOpt.get()));
                        this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new FeedbackAnalyticEvent("servicedesk.action.csat.email.rendered", Long.valueOf(serviceDesk.getProjectId())));
                    }
                }
                if (commentOpt.map(Comment::getBody).exists(StringUtils::isNotBlank)) {
                    this.extractComment(contentParams, (Comment)commentOpt.get());
                }
                ServiceDeskEmailBody serviceDeskEmailBody = this.rendererUtils.renderEmailBodyAsUserPreferredFormat(recipient, "ServiceDesk.Templates.Conversational.onIssueResolved", Option.option((Object)issue), (Map)contentParams.build());
                serviceDeskEmailBody = this.rendererUtils.attachHelpCenterLogo(serviceDeskEmailBody, logoId);
                if (starId != null) {
                    serviceDeskEmailBody = this.feedbackAttachmentManager.attachStarLogo(serviceDeskEmailBody);
                }
                return this.buildServiceDeskEmail(recipient, subject, serviceDeskEmailBody, senderName, issue, serviceDesk);
            });
        });
    }

    @Override
    public Option<ServiceDeskEmail> createParticipantAddedNotification(CheckedUser recipient, String senderName, Issue issue, Portal portal, ServiceDesk serviceDesk, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        return (Option)this.authenticationContextUtil.runAs(recipient.forJIRA(), () -> {
            Option<CustomerRequestView> customerRequestViewOption = this.serviceDeskNotificationContentUtils.getCustomerRequestView(recipient, issue, portal);
            return customerRequestViewOption.flatMap(customerRequestView -> {
                String subject = this.createParticipantAddedSubject(senderName, issue);
                String logoId = ServiceDeskMailUtils.generateServiceDeskEmailContentId();
                ImmutableMap.Builder<String, Object> contentParams = this.includeIssueCommonParams(recipient, issue, portal, serviceDesk, (CustomerRequestView)customerRequestView, logoId, emailAnalyticsEvent);
                contentParams.put((Object)PARTICIPANT_INVITED_BY, (Object)senderName);
                ServiceDeskEmailBody serviceDeskEmailBody = this.rendererUtils.renderEmailBodyAsUserPreferredFormat(recipient, "ServiceDesk.Templates.Conversational.onParticipantAdded", Option.option((Object)issue), (Map)contentParams.build());
                serviceDeskEmailBody = this.rendererUtils.attachHelpCenterLogo(serviceDeskEmailBody, logoId);
                return this.buildServiceDeskEmail(recipient, subject, serviceDeskEmailBody, portal.getName(), issue, serviceDesk);
            });
        });
    }

    @Override
    public Option<ServiceDeskEmail> createIssueReOpenedNotification(CheckedUser recipient, String senderName, Issue issue, Portal portal, ServiceDesk serviceDesk, Option<Comment> commentOpt, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        return (Option)this.authenticationContextUtil.runAs(recipient.forJIRA(), () -> {
            Option<CustomerRequestView> customerRequestViewOption = this.serviceDeskNotificationContentUtils.getCustomerRequestView(recipient, issue, portal);
            return customerRequestViewOption.flatMap(customerRequestView -> {
                String subject = this.createRequestReopenedSubject(issue);
                String logoId = ServiceDeskMailUtils.generateServiceDeskEmailContentId();
                ImmutableMap.Builder<String, Object> contentParams = this.includeIssueCommonParams(recipient, issue, portal, serviceDesk, (CustomerRequestView)customerRequestView, logoId, emailAnalyticsEvent);
                contentParams.put((Object)RESOLVER, (Object)senderName);
                if (commentOpt.map(Comment::getBody).exists(StringUtils::isNotBlank)) {
                    this.extractComment(contentParams, (Comment)commentOpt.get());
                }
                ServiceDeskEmailBody serviceDeskEmailBody = this.rendererUtils.renderEmailBodyAsUserPreferredFormat(recipient, "ServiceDesk.Templates.Conversational.onRequestReopened", Option.option((Object)issue), (Map)contentParams.build());
                serviceDeskEmailBody = this.rendererUtils.attachHelpCenterLogo(serviceDeskEmailBody, logoId);
                return this.buildServiceDeskEmail(recipient, subject, serviceDeskEmailBody, senderName, issue, serviceDesk);
            });
        });
    }

    private String createIssueCreatedSubject(Issue issue) {
        return this.i18nHelper.getText("sd.email.conversational.notification.create.issue.subject", issue.getKey(), issue.getSummary());
    }

    private String createIssueCommentedSubject(Issue issue) {
        return this.i18nHelper.getText("sd.email.conversational.notification.comment.issue.subject", issue.getKey(), issue.getSummary());
    }

    private String createParticipantAddedSubject(String sender, Issue issue) {
        return this.i18nHelper.getText("sd.email.conversational.notification.participant.added.subject", sender, issue.getKey(), issue.getSummary());
    }

    private String createRequestReopenedSubject(Issue issue) {
        return this.i18nHelper.getText("sd.email.conversational.notification.issue.reopened.subject.new", issue.getKey(), issue.getSummary());
    }

    private String createIssueResolvedSubject(Issue issue, String resolution) {
        return this.i18nHelper.getText("sd.email.conversational.notification.resolve.issue.subject", resolution, issue.getKey(), issue.getSummary());
    }

    private String getPortalIssueUrl(Portal portal, Issue issue) {
        String portalIssueUrl = this.notificationMessageContextUtils.getPortalIssueUrl(portal, issue);
        return this.serviceDeskAnalyticsSourceService.enrichURLWithSDASource(portalIssueUrl, "notification-email");
    }

    private String getFeedbackUrl(Portal portal, Issue issue, String token) {
        return this.portalUrlsProvider.getUrls(portal.getId(), ProjectUrlsProvider.UrlMode.ABSOLUTE).feedback(issue.getKey(), token).toString();
    }

    private String getUnsubscribeLink(Issue issue, ApplicationUser user) {
        return (String)this.unsubscribeLinkHelper.getUnsubscribeLink(issue, user).getOrElse((Object)"");
    }

    private Option<String> generateToken(ApplicationUser reporter, Issue issue) {
        Either tokenEither = this.tokenManager.generateFeedbackToken(issue);
        if (tokenEither.isLeft()) {
            this.loggingSupport.log().debug("Cannot generate feedback token", tokenEither.left().get());
            return Option.none();
        }
        ValidatedFeedbackToken validatedFeedbackToken = (ValidatedFeedbackToken)tokenEither.right().get();
        Either storeEither = this.tokenManager.storeFeedbackToken(reporter, validatedFeedbackToken);
        if (storeEither.isLeft()) {
            this.loggingSupport.log().debug("Cannot store feedback token", storeEither.left().get());
            return Option.none();
        }
        return Option.some((Object)((ValidatedFeedbackToken)storeEither.right().get()).getToken());
    }

    private boolean hasValidEmailChannel(ServiceDesk serviceDesk) {
        List<EmailChannelScala> emailChannelList = this.emailPlatformManager.getValidEmailChannelsByServiceDesk(serviceDesk);
        return !emailChannelList.isEmpty();
    }

    private ImmutableMap.Builder<String, Object> includeIssueCommonParams(CheckedUser checkedUser, Issue issue, Portal portal, ServiceDesk serviceDesk, CustomerRequestView customerRequestView, String logoContentId, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        String portalIssueUrl = this.getPortalIssueUrl(portal, issue);
        ImmutableMap.Builder params = this.rendererUtils.commonParameters(checkedUser, Option.option((Object)portal)).put((Object)ISSUE, (Object)customerRequestView).put((Object)PORTAL_URL, (Object)portalIssueUrl).put((Object)UNSUBSCRIBE_LINK, (Object)this.getUnsubscribeLink(issue, checkedUser.forJIRA())).put((Object)PARTICIPANTS_TEXT, (Object)this.renderParticipantList(checkedUser, issue, portalIssueUrl)).put((Object)MARKER_ENABLED, (Object)this.notificationMessageContextUtils.isMarkerInsertionEnabledForServiceDesk(serviceDesk)).put((Object)EMAIL_CHANNEL_SETUP, (Object)this.hasValidEmailChannel(serviceDesk)).put((Object)EMAIL_TRACKING_EVENT_NAME, (Object)emailAnalyticsEvent.getEmailKey());
        if (this.helpCenterBrandingManager.getHelpCenterBranding().getLogoId().isDefined()) {
            params.put((Object)SHARED_PORTAL_LOGO_ID, (Object)logoContentId);
        }
        return params;
    }

    private void extractComment(ImmutableMap.Builder<String, Object> contentParams, Comment comment) {
        String renderedComment = this.customerTextRenderer.renderCommentNotShimmed(comment);
        contentParams.put((Object)COMMENT_TEXT, (Object)comment.getBody());
        contentParams.put((Object)COMMENT_HTML, (Object)renderedComment);
    }

    @VisibleForTesting
    String renderParticipantList(CheckedUser reporter, Issue issue, String url) {
        List participantList = (List)this.requestParticipantsService.getValidParticipants(reporter, issue).fold(error -> Collections.emptyList(), participants -> participants);
        int size = participantList.size();
        if (size > 0) {
            String firstVisibleParticipants = this.renderFirstParticipants(participantList);
            ApplicationUser creator = issue.getReporter();
            if (creator == null || StringUtils.isBlank((String)creator.getDisplayName())) {
                if (size == 1) {
                    return this.i18nHelper.getText(ONE_PARTICIPANT_NO_CREATOR, firstVisibleParticipants);
                }
                if (size <= 3) {
                    return this.i18nHelper.getText(THREE_PARTICIPANTS_NO_CREATOR, firstVisibleParticipants);
                }
                return this.i18nHelper.getText(MORE_PARTICIPANTS_NO_CREATOR, (Object)firstVisibleParticipants, (Object)url, (Object)(size - 3));
            }
            String reporterDisplayName = StringEscapeUtils.escapeHtml((String)creator.getDisplayName());
            if (size == 1) {
                return this.i18nHelper.getText(ONE_PARTICIPANT_WITH_CREATOR, reporterDisplayName, firstVisibleParticipants);
            }
            if (size <= 3) {
                return this.i18nHelper.getText(THREE_PARTICIPANTS_WITH_CREATOR, reporterDisplayName, firstVisibleParticipants);
            }
            return this.i18nHelper.getText(MORE_PARTICIPANTS_WITH_CREATOR, (Object)reporterDisplayName, (Object)firstVisibleParticipants, (Object)url, (Object)(size - 3));
        }
        return "";
    }

    @VisibleForTesting
    String renderFirstParticipants(List<CheckedUser> participantList) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < participantList.size(); ++i) {
            boolean isNotFirst;
            boolean isVisibleParticipant;
            CheckedUser participant = participantList.get(i);
            boolean bl = isVisibleParticipant = i < 3;
            if (!isVisibleParticipant) continue;
            boolean bl2 = isNotFirst = i > 0;
            if (isNotFirst) {
                boolean isLast;
                boolean bl3 = isLast = i == participantList.size() - 1;
                if (isLast) {
                    output.append(" ").append(this.i18nHelper.getText("sd.common.words.and")).append(" ");
                } else {
                    output.append(", ");
                }
            }
            output.append(StringEscapeUtils.escapeHtml((String)participant.getDisplayName()));
        }
        return output.toString();
    }

    private Option<ServiceDeskEmail> buildServiceDeskEmail(CheckedUser recipient, String subject, ServiceDeskEmailBody serviceDeskEmailBody, String fromName, Issue issue, ServiceDesk serviceDesk) {
        ServiceDeskEmail.Builder builder = this.serviceDeskEmailBuilderFactory.newBuilder();
        builder.toAddress(recipient.getEmailAddress()).subject(subject).serviceDeskEmailBody(serviceDeskEmailBody).fromName(fromName).issue(issue);
        this.notificationMessageContextUtils.getFromAddress(issue).foreach(arg_0 -> ((ServiceDeskEmail.Builder)builder).fromAddress(arg_0));
        this.notificationMessageContextUtils.getReplyToHeader(recipient, issue, serviceDesk).foreach(arg_0 -> ((ServiceDeskEmail.Builder)builder).replyToHeader(arg_0));
        return Option.some((Object)builder.build());
    }
}

