/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.internal.api.notifications.FeedbackAttachmentManager;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.notifications.HTMLBody;
import com.atlassian.servicedesk.squalor.email.ServiceDeskMailUtils;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.internet.MimeBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class FeedbackAttachmentManagerImpl
implements FeedbackAttachmentManager {
    private static final Resource STAR_RESOURCE = new ClassPathResource("/img/aui-star.png");
    private static final Logger LOG = LoggerFactory.getLogger(FeedbackAttachmentManager.class);
    private FeatureManager featureManager;

    @Autowired
    public FeedbackAttachmentManagerImpl(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceDeskEmailBody attachStarLogo(ServiceDeskEmailBody emailBody) {
        if (this.featureManager.isEnabled(SDFeatureFlags.NOTIFICATION_UTF8_CSAT_STAR)) return emailBody;
        if (!(emailBody instanceof HTMLBody)) return emailBody;
        HTMLBody htmlBody = (HTMLBody)emailBody;
        try (InputStream inputStream = STAR_RESOURCE.getInputStream();){
            MimeBodyPart bodyPart = ServiceDeskMailUtils.getInlinePNGImagePart((String)"jsd-content-id-star-logo", (InputStream)inputStream);
            ImmutableList bodyPartList = ImmutableList.builder().addAll(htmlBody.getBodyParts()).add((Object)bodyPart).build();
            HTMLBody hTMLBody = new HTMLBody(htmlBody.getBody(), htmlBody.getTextOpt(), (List<BodyPart>)bodyPartList);
            return hTMLBody;
        }
        catch (IOException e) {
            LOG.error("Cannot attach aui-star.png input stream", (Throwable)e);
        }
        return emailBody;
    }
}

