/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.notifications;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.logging.LoggingSupport;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.analytics.emailevents.AgentInviteCustomerEmailSendEvent;
import com.atlassian.servicedesk.internal.api.analytics.emailevents.CannotResetPasswordEmailSendEvent;
import com.atlassian.servicedesk.internal.api.analytics.emailevents.CustomerSignupEmailSendEvent;
import com.atlassian.servicedesk.internal.api.analytics.emailevents.InviteCustomerEmailSendEvent;
import com.atlassian.servicedesk.internal.api.analytics.emailevents.ResetPasswordEmailSendEvent;
import com.atlassian.servicedesk.internal.api.analytics.emailevents.SDEmailAnalyticsEvent;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmail;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.user.InvitationToken;
import com.atlassian.servicedesk.internal.notifications.CustomerConversationalNotificationManager;
import com.atlassian.servicedesk.internal.notifications.CustomerConversationalNotificationRenderer;
import com.atlassian.servicedesk.internal.notifications.ServiceDeskNotificationInternalSender;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerConversationalNotificationManagerImpl
implements CustomerConversationalNotificationManager {
    private CustomerConversationalNotificationRenderer customerConversationalNotificationRenderer;
    private ServiceDeskNotificationInternalSender serviceDeskNotificationSender;
    private InternalPortalService internalPortalService;
    private ApplicationProperties applicationProperties;
    private LoggingSupport loggingSupport;
    private AnalyticsService analyticsService;
    static final String CUSTOMER_PORTAL_BASE_URL = "/servicedesk/customer/portal/";
    static final String VISIT_PORTAL_URL = "/user/visitportal";

    @Autowired
    public CustomerConversationalNotificationManagerImpl(CustomerConversationalNotificationRenderer customerConversationalNotificationRenderer, ServiceDeskNotificationInternalSender serviceDeskNotificationSender, InternalPortalService internalPortalService, ApplicationProperties applicationProperties, LoggingSupport loggingSupport, AnalyticsService analyticsService) {
        this.customerConversationalNotificationRenderer = customerConversationalNotificationRenderer;
        this.serviceDeskNotificationSender = serviceDeskNotificationSender;
        this.internalPortalService = internalPortalService;
        this.applicationProperties = applicationProperties;
        this.loggingSupport = loggingSupport;
        this.analyticsService = analyticsService;
    }

    private void sendEmailAndFireAnalytics(Option<ServiceDeskEmail> serviceDeskEmail, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        serviceDeskEmail.foreach(email -> {
            this.serviceDeskNotificationSender.send((ServiceDeskEmail)email);
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)emailAnalyticsEvent);
        });
    }

    @Override
    public void sendEmailForCustomerSignUp(CheckedUser checkedUser, Option<Portal> portal) {
        CustomerSignupEmailSendEvent emailAnalyticsEvent = new CustomerSignupEmailSendEvent();
        Option<ServiceDeskEmail> serviceDeskEmailOption = this.customerConversationalNotificationRenderer.createCustomerSignUpNotification(checkedUser, portal, (SDEmailAnalyticsEvent)emailAnalyticsEvent);
        this.sendEmailAndFireAnalytics(serviceDeskEmailOption, (SDEmailAnalyticsEvent)emailAnalyticsEvent);
    }

    @Override
    public void sendEmailForResetPassword(CheckedUser checkedUser, Option<Portal> portalOption, UserUtil.PasswordResetToken passwordResetToken) {
        ResetPasswordEmailSendEvent emailAnalyticsEvent = new ResetPasswordEmailSendEvent();
        Option<ServiceDeskEmail> serviceDeskEmailOption = this.customerConversationalNotificationRenderer.createResetPasswordNotification(checkedUser, portalOption, passwordResetToken, (SDEmailAnalyticsEvent)emailAnalyticsEvent);
        this.sendEmailAndFireAnalytics(serviceDeskEmailOption, (SDEmailAnalyticsEvent)emailAnalyticsEvent);
    }

    @Override
    public void sendEmailForAgentInviteCustomer(CheckedUser user, CheckedUser customer, Project project, Option<InvitationToken> invitationTokenOption) {
        AgentInviteCustomerEmailSendEvent emailAnalyticsEvent = new AgentInviteCustomerEmailSendEvent();
        Option<ServiceDeskEmail> serviceDeskEmailOption = this.buildCustomerInvitation(user, customer, project, invitationTokenOption, (SDEmailAnalyticsEvent)emailAnalyticsEvent);
        this.sendEmailAndFireAnalytics(serviceDeskEmailOption, (SDEmailAnalyticsEvent)emailAnalyticsEvent);
    }

    @Override
    public void sendEmailForCustomerInvitationViaEmailChannel(CheckedUser customer, Project project, Option<InvitationToken> invitationTokenOpt) {
        String invitationLink = this.getCustomerInviteURL(customer, project);
        invitationLink = this.decorateInviteUrlWithParam(customer, invitationTokenOpt, invitationLink);
        InviteCustomerEmailSendEvent emailAnalyticsEvent = new InviteCustomerEmailSendEvent();
        Option<ServiceDeskEmail> serviceDeskEmailOption = this.customerConversationalNotificationRenderer.createCustomerInvitationViaEmailChannelNotification(customer, project, invitationLink, (SDEmailAnalyticsEvent)emailAnalyticsEvent);
        this.sendEmailAndFireAnalytics(serviceDeskEmailOption, (SDEmailAnalyticsEvent)emailAnalyticsEvent);
    }

    @Override
    public void sendEmailForCannotResetPassword(CheckedUser checkedUser, Option<Portal> portalOption) {
        CannotResetPasswordEmailSendEvent emailAnalyticsEvent = new CannotResetPasswordEmailSendEvent();
        Option<ServiceDeskEmail> serviceDeskEmailOption = this.customerConversationalNotificationRenderer.createCannotResetPasswordNotification(checkedUser, portalOption, (SDEmailAnalyticsEvent)emailAnalyticsEvent);
        this.sendEmailAndFireAnalytics(serviceDeskEmailOption, (SDEmailAnalyticsEvent)emailAnalyticsEvent);
    }

    private Option<ServiceDeskEmail> buildCustomerInvitation(CheckedUser user, CheckedUser customer, Project project, Option<InvitationToken> invitationTokensOpt, SDEmailAnalyticsEvent emailAnalyticsEvent) {
        String invitationLink = this.getCustomerInviteURL(user, project);
        invitationLink = this.decorateInviteUrlWithParam(customer, invitationTokensOpt, invitationLink);
        return this.customerConversationalNotificationRenderer.createAgentInviteCustomerNotification(user, customer, project, invitationLink, emailAnalyticsEvent);
    }

    private String getCustomerInviteURL(CheckedUser user, Project project) {
        Either<AnError, Portal> portalEither = this.internalPortalService.getPortalByProject(user, project);
        if (portalEither.isLeft()) {
            return "";
        }
        Portal portal = (Portal)portalEither.right().get();
        return CUSTOMER_PORTAL_BASE_URL + portal.getId() + VISIT_PORTAL_URL;
    }

    private String decorateInviteUrlWithParam(CheckedUser user, Option<InvitationToken> invitationTokenOption, String invitationLink) {
        String encodedUserName = user.getName();
        try {
            encodedUserName = URLEncoder.encode(user.getName(), this.applicationProperties.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            this.loggingSupport.log().error("Cannot encode user name: " + encodedUserName, (Throwable)e);
        }
        StringBuilder sb = new StringBuilder(invitationLink);
        sb.append("?username=").append(encodedUserName);
        if (invitationTokenOption.isDefined()) {
            String tokenValue = ((InvitationToken)invitationTokenOption.get()).getValue();
            sb.append("&token=").append(tokenValue);
        }
        return sb.toString();
    }
}

