/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.jackson.serializer;

import io.atlassian.fugue.Option;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;
import org.codehaus.jackson.map.ser.impl.SimpleBeanPropertyFilter;

public class OptionFilter
extends SimpleBeanPropertyFilter {
    public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov, BeanPropertyWriter writer) throws Exception {
        if (bean == null) {
            return;
        }
        if (writer.getPropertyType() == Option.class) {
            String propertyName = writer.getName();
            Method getter = this.findGetterMethod(bean, propertyName);
            Option optionAttribute = null;
            if (getter != null) {
                optionAttribute = (Option)getter.invoke(bean, new Object[0]);
            } else {
                Field field = this.findField(bean, propertyName);
                if (field != null) {
                    optionAttribute = (Option)field.get(bean);
                }
            }
            if (optionAttribute == null || optionAttribute.isEmpty() || optionAttribute.get() == null) {
                return;
            }
        }
        writer.serializeAsField(bean, jgen, prov);
    }

    private Method findGetterMethod(Object bean, String name) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptors;
        for (PropertyDescriptor pd : propertyDescriptors = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors()) {
            if (!pd.getName().equalsIgnoreCase(name)) continue;
            return pd.getReadMethod();
        }
        return null;
    }

    private Field findField(Object bean, String name) {
        try {
            Field field = bean.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }
}

