/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.issue.issuelist;

import com.atlassian.servicedesk.internal.feature.jira.issue.IssueHashData;
import com.atlassian.servicedesk.internal.issue.issuelist.IssueListHasher;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class Sha1IssueListHasher
implements IssueListHasher {
    @Override
    public String hash(@Nonnull List<IssueHashData> issueList, long totalIssueCount) {
        Assertions.notNull((String)"issueList", issueList);
        String issueListString = totalIssueCount + this.stringifyIssueList(issueList);
        return this.hashIssueList(issueListString);
    }

    private String stringifyIssueList(List<IssueHashData> issueList) {
        List issueStrings = Lists.transform(issueList, (Function)new Function<IssueHashData, String>(){

            public String apply(IssueHashData issue) {
                return issue.getKey() + issue.getUpdated().toString();
            }
        });
        return StringUtils.join((Collection)issueStrings, (String)"");
    }

    private String hashIssueList(String issueListString) {
        return DigestUtils.sha1Hex((String)issueListString);
    }
}

