/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.issue.issuelist;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.issue.issuelist.ServiceDeskIssueList;
import com.atlassian.servicedesk.internal.issue.issuelist.views.IssueListColumnView;
import com.atlassian.servicedesk.internal.issue.issuelist.views.IssueListFieldView;
import com.atlassian.servicedesk.internal.issue.issuelist.views.IssueListIssueView;
import com.atlassian.servicedesk.internal.issue.issuelist.views.ServiceDeskIssueListView;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueListVisualiser {
    private final I18nHelper.BeanFactory i18nFactory;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;

    @Autowired
    public IssueListVisualiser(I18nHelper.BeanFactory i18nFactory, FieldScreenRendererFactory fieldScreenRendererFactory) {
        this.i18nFactory = i18nFactory;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
    }

    public ServiceDeskIssueListView getIssueListView(@Nonnull CheckedUser user, @Nonnull ServiceDeskIssueList issueList) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"issueList", (Object)issueList);
        final I18nHelper i18nHelper = this.i18nFactory.getInstance(user.forJIRA());
        List<NavigableField> columnFields = issueList.getColumns();
        List columnViews = Lists.transform(columnFields, (Function)new Function<NavigableField, IssueListColumnView>(){

            public IssueListColumnView apply(NavigableField field) {
                String columnHeaderText = i18nHelper.getText(field.getColumnHeadingKey());
                return new IssueListColumnView(columnHeaderText, field.getId());
            }
        });
        List<IssueListIssueView> issueViews = this.getIssueViews(issueList);
        return new ServiceDeskIssueListView(issueViews, columnViews);
    }

    private List<IssueListIssueView> getIssueViews(ServiceDeskIssueList issueList) {
        ArrayList issueViews = Lists.newArrayList();
        int i = 0;
        while (i < issueList.getIssues().size()) {
            Issue issue = issueList.getIssues().get(i);
            List<IssueListFieldView> fieldsAsViews = this.mapFieldsToFieldViews(issue, issueList.getColumns());
            int issuePosition = i++;
            issueViews.add(new IssueListIssueView(issue.getKey(), fieldsAsViews, issuePosition));
        }
        return issueViews;
    }

    private List<IssueListFieldView> mapFieldsToFieldViews(final Issue issue, List<NavigableField> fields) {
        return Lists.transform(fields, (Function)new Function<NavigableField, IssueListFieldView>(){

            public IssueListFieldView apply(NavigableField navigableField) {
                FieldScreenRenderer fieldScreenRenderer = IssueListVisualiser.this.fieldScreenRendererFactory.getFieldScreenRenderer(issue);
                FieldLayoutItem fieldLayoutItem = fieldScreenRenderer.getFieldLayout().getFieldLayoutItem(navigableField.getId());
                return new IssueListFieldView(navigableField.getColumnViewHtml(fieldLayoutItem, new HashMap(), issue), navigableField.getColumnCssClass());
            }
        });
    }
}

