/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.fields.renderer;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.customfields.impl.DateCFType;
import com.atlassian.jira.issue.customfields.impl.DateTimeCFType;
import com.atlassian.jira.issue.customfields.impl.LabelsCFType;
import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.issue.customfields.impl.MultiUserCFType;
import com.atlassian.jira.issue.customfields.impl.RenderableTextCFType;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.customer.request.fields.FieldValue;
import com.atlassian.servicedesk.internal.feature.customer.request.fields.TextValue;
import com.atlassian.servicedesk.internal.fields.ServiceDeskJIRAFieldService;
import com.atlassian.servicedesk.internal.fields.renderer.FieldRenderingHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CustomFieldFieldValueRenderer
implements ServiceDeskJIRAFieldService.FieldValueRenderer {
    private final CustomFieldManager customFieldManager;
    private final FieldRenderingHelper fieldRenderingHelper;
    private final DoubleConverter doubleConverter;
    private final CheckedUser user;
    private final String fieldId;

    public CustomFieldFieldValueRenderer(CustomFieldManager customFieldManager, FieldRenderingHelper fieldRenderingHelper, DoubleConverter doubleConverter, CheckedUser user, String fieldId) {
        this.customFieldManager = customFieldManager;
        this.fieldRenderingHelper = fieldRenderingHelper;
        this.doubleConverter = doubleConverter;
        this.user = user;
        this.fieldId = fieldId;
    }

    @Override
    public io.atlassian.fugue.Option<FieldValue> apply(Issue issue) {
        CustomField customField = this.customFieldManager.getCustomFieldObject(this.fieldId);
        return io.atlassian.fugue.Option.option((Object)customField).map(cf -> this.getRendererForCustomField(issue, this.user, (CustomField)cf)).flatMap(f -> (io.atlassian.fugue.Option)f.apply(issue));
    }

    private Function<Issue, io.atlassian.fugue.Option<FieldValue>> getRendererForCustomField(Issue issue, CheckedUser user, CustomField field) {
        return new LazyCustomFieldRenderer(this.fieldRenderingHelper, this.doubleConverter, issue, user, field);
    }

    private static Function<Object, io.atlassian.fugue.Option<FieldValue>> findValueConverter(FieldRenderingHelper grh, DoubleConverter doubleConverter, Issue issue, CheckedUser user, CustomField field, io.atlassian.fugue.Option<Object> value) {
        if (CustomFieldFieldValueRenderer.isType(value, ApplicationUser.class)) {
            return userFieldValue -> io.atlassian.fugue.Option.some((Object)new TextValue(((ApplicationUser)userFieldValue).getDisplayName()));
        }
        if (CustomFieldFieldValueRenderer.isType(value, Option.class)) {
            return option -> io.atlassian.fugue.Option.some((Object)new TextValue(CustomFieldFieldValueRenderer.getCFOptionValue(option)));
        }
        if (CustomFieldFieldValueRenderer.isType(value, String.class)) {
            return s -> io.atlassian.fugue.Option.some((Object)new TextValue((String)s));
        }
        if (CustomFieldFieldValueRenderer.isType(value, Double.class)) {
            return d -> io.atlassian.fugue.Option.some((Object)new TextValue(doubleConverter.getString((Double)d)));
        }
        CustomFieldType customFieldType = field.getCustomFieldType();
        if (customFieldType instanceof RenderableTextCFType) {
            return cfValue -> io.atlassian.fugue.Option.option((Object)grh.getRenderedFieldValue(user, issue, field.getId(), (String)cfValue));
        }
        if (customFieldType instanceof MultiSelectCFType) {
            return cfValue -> CustomFieldFieldValueRenderer.joinStringValues((Collection)cfValue, CustomFieldFieldValueRenderer::getCFOptionValue);
        }
        if (customFieldType instanceof CascadingSelectCFType) {
            return cfValue -> CustomFieldFieldValueRenderer.joinMapValues((Map)cfValue, CustomFieldFieldValueRenderer::getCFOptionValue);
        }
        if (customFieldType instanceof DateCFType) {
            return d -> io.atlassian.fugue.Option.some((Object)new TextValue(customFieldType.getStringFromSingularObject(d)));
        }
        if (customFieldType instanceof DateTimeCFType) {
            return d -> io.atlassian.fugue.Option.some((Object)new TextValue(customFieldType.getStringFromSingularObject(d)));
        }
        if (customFieldType instanceof MultiUserCFType) {
            return cfValue -> CustomFieldFieldValueRenderer.joinStringValues((Collection)cfValue, ApplicationUser::getDisplayName);
        }
        if (customFieldType instanceof LabelsCFType) {
            return cfValue -> CustomFieldFieldValueRenderer.joinStringValues((Collection)cfValue, Label::getLabel);
        }
        return nah -> io.atlassian.fugue.Option.none();
    }

    private static <T> io.atlassian.fugue.Option<FieldValue> joinStringValues(Collection<T> cfValue, Function<T, String> toString) {
        String options = ((Collection)io.atlassian.fugue.Option.option(cfValue).getOr(Collections::emptySet)).stream().map(toString).collect(Collectors.joining(", "));
        return io.atlassian.fugue.Option.some((Object)new TextValue(options));
    }

    private static <K, V> io.atlassian.fugue.Option<FieldValue> joinMapValues(Map<K, V> cfValue, Function<V, String> toString) {
        String options = ((Map)io.atlassian.fugue.Option.option(cfValue).getOr(Collections::emptyMap)).values().stream().map(toString).collect(Collectors.joining(" - "));
        return io.atlassian.fugue.Option.some((Object)new TextValue(options));
    }

    private static <C> boolean isType(io.atlassian.fugue.Option<Object> value, Class<C> clazz) {
        return value.exists(o -> clazz.isAssignableFrom(o.getClass()));
    }

    private static String getCFOptionValue(Object option) {
        return ((Option)option).getValue();
    }

    private static class LazyCustomFieldRenderer
    implements Function<Issue, io.atlassian.fugue.Option<FieldValue>> {
        private final FieldRenderingHelper fieldRenderingHelper;
        private final DoubleConverter doubleConverter;
        private final Issue issue;
        private final CheckedUser user;
        private final CustomField field;

        private LazyCustomFieldRenderer(FieldRenderingHelper fieldRenderingHelper, DoubleConverter doubleConverter, Issue issue, CheckedUser user, CustomField field) {
            this.fieldRenderingHelper = fieldRenderingHelper;
            this.doubleConverter = doubleConverter;
            this.issue = issue;
            this.user = user;
            this.field = field;
        }

        @Override
        public io.atlassian.fugue.Option<FieldValue> apply(Issue issue) {
            io.atlassian.fugue.Option value = io.atlassian.fugue.Option.option((Object)this.field.getValue(issue));
            Function valueConverter = CustomFieldFieldValueRenderer.findValueConverter(this.fieldRenderingHelper, this.doubleConverter, issue, this.user, this.field, (io.atlassian.fugue.Option<Object>)value);
            return value.flatMap(valueConverter);
        }
    }
}

