/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.fields;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItemImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.field.PartialRequestTypeField;
import com.atlassian.servicedesk.internal.fields.ServiceDeskJIRAFieldService;
import com.atlassian.servicedesk.internal.fields.ServiceDeskJIRAFieldServiceScala;
import com.atlassian.servicedesk.internal.utils.DateFormatter;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskJIRAFieldServiceImpl
implements ServiceDeskJIRAFieldService {
    private final FieldLayoutManager fieldLayoutManager;
    private final FieldManager fieldManager;
    private final ServiceDeskJIRAFieldServiceScala scalaDelegate;

    @Autowired
    public ServiceDeskJIRAFieldServiceImpl(FieldLayoutManager fieldLayoutManager, FieldManager fieldManager, ServiceDeskJIRAFieldServiceScala scalaDelegate) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.fieldManager = fieldManager;
        this.scalaDelegate = scalaDelegate;
    }

    @Override
    public boolean isFieldPresentInAllFieldLayoutItems(Project project, IssueType issueType, OrderableField orderableField) {
        return this.getAllFields(project, issueType).stream().anyMatch(fieldLayoutItem -> Objects.equals(orderableField.getId(), fieldLayoutItem.getOrderableField().getId()));
    }

    @Override
    public List<FieldLayoutItem> getAllFields(Project project, IssueType issueType) {
        String issueTypeId = issueType.getId();
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(project, issueTypeId);
        return fieldLayout.getVisibleLayoutItems(project, Collections.singletonList(issueTypeId));
    }

    @Override
    public List<FieldLayoutItem> getRequiredFields(Project project, IssueType issueType) {
        String issueTypeId = issueType.getId();
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(project, issueTypeId);
        ArrayList<FieldLayoutItem> fieldLayoutItems = new ArrayList<FieldLayoutItem>(fieldLayout.getVisibleLayoutItems(project, Collections.singletonList(issueTypeId)));
        if (!this.hasSummary(fieldLayoutItems)) {
            OrderableField summary = this.fieldManager.getOrderableField("summary");
            FieldLayoutItemImpl summaryFieldLayoutItem = new FieldLayoutItemImpl.Builder().setFieldLayout(fieldLayout).setFieldManager(this.fieldManager).setHidden(false).setRequired(true).setOrderableField(summary).build();
            fieldLayoutItems.add(0, (FieldLayoutItem)summaryFieldLayoutItem);
        }
        return fieldLayoutItems.stream().filter(FieldLayoutItem::isRequired).collect(Collectors.toList());
    }

    @Override
    public List<NavigableField> getNavigableFields(CheckedUser user, List<String> fieldIds) {
        try {
            Set allFields = this.fieldManager.getAvailableNavigableFields(user.forJIRA());
            return fieldIds.stream().flatMap(fieldId -> allFields.stream().filter(field -> fieldId.equals(field.getId()))).collect(Collectors.toList());
        }
        catch (FieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<PartialRequestTypeField> getRequiredFieldsAsPartialRequestTypeField(Project project, IssueType issueType) {
        return this.scalaDelegate.getRequiredFieldsAsPartialRequestTypeField(project, issueType);
    }

    @Override
    public Option<ServiceDeskJIRAFieldService.FieldValueRenderer> getFieldValueRenderer(String fieldId, DateFormatter dateFormat, CheckedUser user, Issue issue) {
        return this.scalaDelegate.getFieldValueRenderer(fieldId, dateFormat, user, issue);
    }

    private boolean hasSummary(List<FieldLayoutItem> fieldLayoutItems) {
        return fieldLayoutItems.stream().anyMatch(fieldLayoutItem -> Objects.equals(fieldLayoutItem.getOrderableField().getId(), "summary"));
    }
}

