/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.servicedesk.history;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import io.atlassian.fugue.Maybe;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskUserHistoryService {
    private final UserHistoryManager userHistoryManager;
    private final InternalServiceDeskService serviceDeskService;
    private final InternalServiceDeskProjectManager projectManager;
    private final ServiceDeskLicenseAndPermissionService permissionService;
    static final UserHistoryItem.Type SD_TYPE = UserHistoryItem.Type.getInstance((String)"ServDesk");

    @Autowired
    public ServiceDeskUserHistoryService(UserHistoryManager userHistoryManager, InternalServiceDeskService serviceDeskService, InternalServiceDeskProjectManager projectManager, ServiceDeskLicenseAndPermissionService permissionService) {
        this.userHistoryManager = userHistoryManager;
        this.serviceDeskService = serviceDeskService;
        this.projectManager = projectManager;
        this.permissionService = permissionService;
    }

    public void addProjectToHistory(CheckedUser user, Project project) {
        String projectId = String.valueOf(project.getId());
        this.userHistoryManager.addItemToHistory(SD_TYPE, user.forJIRA(), projectId);
        this.userHistoryManager.addItemToHistory(UserHistoryItem.PROJECT, user.forJIRA(), projectId);
    }

    public Optional<Project> getLatestServiceDeskProjectForAgent(CheckedUser user) {
        return this.getLatestServiceDeskProject(user, project -> this.serviceDeskService.isServiceDeskEnabledForUser(user, project) && this.permissionService.canViewAgentView((SDUser)user, project));
    }

    protected Optional<Project> getLatestServiceDeskProject(CheckedUser user, Predicate<Project> filter2) {
        List history = this.userHistoryManager.getHistory(SD_TYPE, user.forJIRA());
        return history.stream().map(userHistoryItem -> {
            Long projectId = Long.valueOf(userHistoryItem.getEntityId());
            return this.projectManager.getProject(projectId).toOption();
        }).filter(projectOpt -> projectOpt.exists(filter2)).map(Maybe::get).findFirst();
    }
}

