/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.servicedesk;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.util.fp.FpKit;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDesk;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskQStore;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.atlassian.servicedesk.internal.querydsl.mapping.jira.JiraTables;
import com.atlassian.servicedesk.internal.utils.DateTimeUtils;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskQStoreImpl
implements ServiceDeskQStore {
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public ServiceDeskQStoreImpl(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    private static ConstructorExpression<ServiceDesk> serviceDeskProjection() {
        return Projections.constructor(ServiceDesk.class, (Expression[])new Expression[]{Tables.SERVICE_DESK.ID, Tables.SERVICE_DESK.PROJECT_ID, JiraTables.PROJECT.NAME, Tables.SERVICE_DESK.PUBLIC_SIGNUP, Tables.SERVICE_DESK.OPEN_CUSTOMER_ACCESS, Tables.SERVICE_DESK.CREATED_BY_USER_KEY, Tables.SERVICE_DESK.CREATED_DATE, Tables.SERVICE_DESK.CREATED_WITH_EMPTY_PROJECT, Tables.SERVICE_DESK.VERSION_CREATED_AT, Tables.SERVICE_DESK.LEGACY_TRANSITION_DISABLED});
    }

    private List<com.atlassian.servicedesk.api.ServiceDesk> toApi(List<ServiceDesk> list) {
        return FpKit.map(list, sd -> sd);
    }

    @Override
    public List<com.atlassian.servicedesk.api.ServiceDesk> getServiceDesks() {
        List list = (List)this.databaseAccessor.run(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select(ServiceDeskQStoreImpl.serviceDeskProjection()).from((Expression)Tables.SERVICE_DESK)).innerJoin((EntityPath)JiraTables.PROJECT)).on((Predicate)Tables.SERVICE_DESK.PROJECT_ID.eq(JiraTables.PROJECT.ID))).orderBy(JiraTables.PROJECT.NAME.asc())).fetch());
        return this.toApi(list);
    }

    @Override
    public Option<com.atlassian.servicedesk.api.ServiceDesk> getServiceDeskByProjectIdForDeletion(long projectId) {
        ServiceDesk serviceDesk = (ServiceDesk)this.databaseAccessor.run(conn -> (ServiceDesk)((SQLQuery)((SQLQuery)conn.select((Expression)Projections.constructor(ServiceDesk.class, (Expression[])new Expression[]{Tables.SERVICE_DESK.ID, Tables.SERVICE_DESK.PROJECT_ID, Expressions.constant((Object)""), Tables.SERVICE_DESK.PUBLIC_SIGNUP, Tables.SERVICE_DESK.OPEN_CUSTOMER_ACCESS, Tables.SERVICE_DESK.CREATED_BY_USER_KEY, Tables.SERVICE_DESK.CREATED_DATE, Tables.SERVICE_DESK.CREATED_WITH_EMPTY_PROJECT, Tables.SERVICE_DESK.VERSION_CREATED_AT, Tables.SERVICE_DESK.LEGACY_TRANSITION_DISABLED})).from((Expression)Tables.SERVICE_DESK)).where((Predicate)Tables.SERVICE_DESK.PROJECT_ID.eq((Object)projectId))).fetchOne());
        return Option.option((Object)serviceDesk);
    }

    @Override
    public Option<com.atlassian.servicedesk.api.ServiceDesk> addServiceDesk(String userKey, long projectId, boolean isOpenCustomerAccess2, boolean isEmptyProject, String versionCreatedAt) {
        return (Option)this.databaseAccessor.run(conn -> {
            if (this.isServiceDeskExistsForProject(projectId, (DatabaseConnection)conn)) {
                return Option.none();
            }
            Integer id = (Integer)conn.insert((RelationalPath)Tables.SERVICE_DESK).set((Path)Tables.SERVICE_DESK.PROJECT_KEY, (Object)"_UNUSED").set(Tables.SERVICE_DESK.PROJECT_ID, (Object)projectId).set(Tables.SERVICE_DESK.OPEN_CUSTOMER_ACCESS, (Object)(isOpenCustomerAccess2 ? 1 : 0)).set((Path)Tables.SERVICE_DESK.CREATED_WITH_EMPTY_PROJECT, (Object)isEmptyProject).set((Path)Tables.SERVICE_DESK.CREATED_BY_USER_KEY, (Object)userKey).set(Tables.SERVICE_DESK.CREATED_DATE, (Object)DateTimeUtils.getCurrentTimestamp()).set((Path)Tables.SERVICE_DESK.VERSION_CREATED_AT, (Object)versionCreatedAt).set((Path)Tables.SERVICE_DESK.LEGACY_TRANSITION_DISABLED, (Object)true).executeWithKey(Tables.SERVICE_DESK.ID);
            return Option.option((Object)this.getServiceDeskById((DatabaseConnection)conn, id));
        });
    }

    private boolean isServiceDeskExistsForProject(long projectId, DatabaseConnection conn) {
        return ((SQLQuery)((SQLQuery)conn.select(Tables.SERVICE_DESK.ID).from((Expression)Tables.SERVICE_DESK)).where((Predicate)Tables.SERVICE_DESK.PROJECT_ID.eq((Object)projectId))).fetchCount() > 0L;
    }

    private ServiceDesk getServiceDeskById(DatabaseConnection conn, Integer id) {
        return (ServiceDesk)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)conn.select(ServiceDeskQStoreImpl.serviceDeskProjection()).from((Expression)Tables.SERVICE_DESK)).innerJoin((EntityPath)JiraTables.PROJECT)).on((Predicate)Tables.SERVICE_DESK.PROJECT_ID.eq(JiraTables.PROJECT.ID))).where((Predicate)Tables.SERVICE_DESK.ID.eq((Object)id))).fetchOne();
    }

    @Override
    public Option<com.atlassian.servicedesk.api.ServiceDesk> deleteServiceDesk(int serviceDeskId) {
        return (Option)this.databaseAccessor.runInTransaction(conn -> {
            ServiceDesk serviceDesk = this.getServiceDeskById((DatabaseConnection)conn, serviceDeskId);
            conn.delete((RelationalPath)Tables.SERVICE_DESK).where((Predicate)Tables.SERVICE_DESK.ID.eq((Object)serviceDeskId)).execute();
            return Option.option((Object)serviceDesk);
        });
    }

    @Override
    public Option<com.atlassian.servicedesk.api.ServiceDesk> updateServiceDeskAccess(int serviceDeskId, boolean isOpenCustomerAccess2, boolean isPublicSignUpEnabled) {
        return (Option)this.databaseAccessor.runInTransaction(conn -> {
            conn.update((RelationalPath)Tables.SERVICE_DESK).set(Tables.SERVICE_DESK.OPEN_CUSTOMER_ACCESS, (Object)(isOpenCustomerAccess2 ? 1 : 0)).set(Tables.SERVICE_DESK.PUBLIC_SIGNUP, (Object)(isPublicSignUpEnabled ? 1 : 0)).where((Predicate)Tables.SERVICE_DESK.ID.eq((Object)serviceDeskId)).execute();
            return Option.option((Object)this.getServiceDeskById((DatabaseConnection)conn, serviceDeskId));
        });
    }

    @Override
    public Option<com.atlassian.servicedesk.api.ServiceDesk> updateLegacyCommentTransitionDisabled(int serviceDeskId, boolean disabled) {
        return (Option)this.databaseAccessor.runInTransaction(conn -> {
            conn.update((RelationalPath)Tables.SERVICE_DESK).set((Path)Tables.SERVICE_DESK.LEGACY_TRANSITION_DISABLED, (Object)disabled).where((Predicate)Tables.SERVICE_DESK.ID.eq((Object)serviceDeskId)).execute();
            return Option.option((Object)this.getServiceDeskById((DatabaseConnection)conn, serviceDeskId));
        });
    }
}

