/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.servicedesk;

import com.atlassian.servicedesk.internal.feature.customer.user.signup.GlobalPublicSignupManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.InternalServiceDeskAccessManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDesk;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InternalServiceDeskAccessManagerImpl
implements InternalServiceDeskAccessManager {
    private final GlobalPublicSignupManager globalPublicSignupManager;
    private final ServiceDeskInternalManager serviceDeskInternalManager;

    @Autowired
    public InternalServiceDeskAccessManagerImpl(GlobalPublicSignupManager globalPublicSignupManager, ServiceDeskInternalManager serviceDeskInternalManager) {
        this.globalPublicSignupManager = globalPublicSignupManager;
        this.serviceDeskInternalManager = serviceDeskInternalManager;
    }

    @Override
    public boolean isOpenAccess(com.atlassian.servicedesk.api.ServiceDesk serviceDesk) {
        return this.toImpl(serviceDesk).accessConfig().openAccess();
    }

    @Override
    public boolean isPublicSignupEnabled(com.atlassian.servicedesk.api.ServiceDesk serviceDesk) {
        return this.globalPublicSignupManager.isGlobalPublicSignupEnabled() && this.isProjectLevelSignupSettingEnabled(serviceDesk);
    }

    @Override
    public boolean isProjectLevelSignupSettingEnabled(com.atlassian.servicedesk.api.ServiceDesk serviceDesk) {
        return this.toImpl(serviceDesk).accessConfig().publicSignUp();
    }

    @Override
    public boolean hasAnyServiceDesksWithPublicSignup() {
        return this.globalPublicSignupManager.isGlobalPublicSignupEnabled() && this.serviceDeskInternalManager.getAllEnabledServiceDesks().stream().anyMatch(this::isProjectLevelSignupSettingEnabled);
    }

    private ServiceDesk toImpl(com.atlassian.servicedesk.api.ServiceDesk serviceDesk) {
        return (ServiceDesk)serviceDesk;
    }
}

