/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants.permission;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.permission.outsider.OutsiderPermissionChecker;
import com.atlassian.servicedesk.internal.feature.jira.issue.IssueHelper;
import com.atlassian.servicedesk.internal.feature.reqparticipants.field.RequestParticipantsInternalManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.permission.RequestParticipantPermissionService;
import com.atlassian.servicedesk.internal.feature.reqparticipants.settings.ParticipantSettingsService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.atlassian.servicedesk.workinprogressapi.participantsettings.ParticipantSettingsConfiguration;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestParticipantPermissionServiceImpl
implements RequestParticipantPermissionService {
    private final RequestParticipantsInternalManager requestParticipantManager;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final CustomerContextService customerContextService;
    private final ParticipantSettingsService participantSettingsService;
    private final PermissionManager permissionManager;
    private final IssueHelper issueHelper;
    private final ServiceDeskService serviceDeskService;
    private final OutsiderPermissionChecker outsiderPermissionChecker;
    private final FeatureManager featureManager;

    @Autowired
    public RequestParticipantPermissionServiceImpl(RequestParticipantsInternalManager requestParticipantManager, ServiceDeskPermissions serviceDeskPermissions, CustomerContextService customerContextService, ParticipantSettingsService participantSettingsService, PermissionManager permissionManager, IssueHelper issueHelper, ServiceDeskService serviceDeskService, FeatureManager featureManager, OutsiderPermissionChecker outsiderPermissionChecker) {
        this.requestParticipantManager = requestParticipantManager;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.customerContextService = customerContextService;
        this.participantSettingsService = participantSettingsService;
        this.permissionManager = permissionManager;
        this.issueHelper = issueHelper;
        this.serviceDeskService = serviceDeskService;
        this.featureManager = featureManager;
        this.outsiderPermissionChecker = outsiderPermissionChecker;
    }

    @Override
    public boolean canAddAnyParticipant(CheckedUser user, Issue issue) {
        Project project = (Project)this.issueHelper.getProjectFromIssue(issue).getOrNull();
        if (project == null) {
            return false;
        }
        if (!this.permissionManager.hasPermission(ProjectPermissions.EDIT_ISSUES, issue, user.forJIRA())) {
            return false;
        }
        if (this.serviceDeskPermissions.canViewAgentView((SDUser)user, project)) {
            return true;
        }
        ServiceDesk serviceDesk = (ServiceDesk)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), project).getOrNull();
        if (serviceDesk == null) {
            return false;
        }
        if (this.serviceDeskPermissions.canViewRequestInPortal((SDUser)user, issue) && !this.outsiderPermissionChecker.isUserAnOutsider(user, issue)) {
            return this.participantSettingsService.isManageParticipantsSettingEnabled(serviceDesk);
        }
        return false;
    }

    @Override
    public boolean canCreateRequestWithAnyParticipant(CheckedUser user, ServiceDesk serviceDesk, Project project) {
        if (this.serviceDeskPermissions.canViewAgentView((SDUser)user, project)) {
            return true;
        }
        boolean canCreate = (Boolean)this.customerContextService.runInCustomerContext(() -> this.serviceDeskPermissions.canViewPortal((SDUser)user, project) && this.serviceDeskPermissions.canCreateRequest((SDUser)user, project) && this.participantSettingsService.isManageParticipantsSettingEnabled(serviceDesk));
        return canCreate;
    }

    @Override
    public boolean canSearchForAnyParticipantForIssue(CheckedUser user, Issue issue, Project project, ServiceDesk serviceDesk) {
        return this.canSearchForAnyParticipant(user, (Option<Issue>)Option.some((Object)issue), project, serviceDesk);
    }

    @Override
    public boolean canSearchForAnyParticipantForProject(CheckedUser user, Project project, ServiceDesk serviceDesk) {
        return this.canSearchForAnyParticipant(user, (Option<Issue>)Option.none(), project, serviceDesk);
    }

    @Override
    public boolean canRemoveAnyParticipant(CheckedUser checkedUser, Issue issue) {
        boolean isAgent2 = this.serviceDeskPermissions.canViewAgentView((SDUser)checkedUser, issue);
        boolean isReporter = this.serviceDeskPermissions.userIsReporterOfIssue((SDUser)checkedUser, issue);
        boolean isParticipant = this.requestParticipantManager.isUserInParticipantList(checkedUser, issue);
        return isAgent2 || isReporter || isParticipant;
    }

    private boolean canSearchForAnyParticipant(CheckedUser user, Option<Issue> issueOpt, Project project, ServiceDesk serviceDesk) {
        if (this.serviceDeskPermissions.canViewAgentView((SDUser)user, project)) {
            return true;
        }
        ParticipantSettingsConfiguration participantSettings = this.participantSettingsService.getSettingsForServiceDesk(user, serviceDesk);
        if (this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS) && !participantSettings.getParticipantManagementEnabled()) {
            return false;
        }
        if (participantSettings.getParticipantAutocompleteEnabled()) {
            return (Boolean)issueOpt.fold(() -> this.serviceDeskPermissions.canViewPortal((SDUser)user, project), issue -> this.serviceDeskPermissions.canViewRequestInPortal((SDUser)user, (Issue)issue));
        }
        return false;
    }
}

