/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants.organization;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.feature.reqparticipants.organization.CustomerOrganizationParticipantService;
import com.atlassian.servicedesk.internal.api.permission.outsider.OutsiderPermissionChecker;
import com.atlassian.servicedesk.internal.feature.organization.error.CustomerOrganizationError;
import com.atlassian.servicedesk.internal.feature.organization.member.CustomerOrganizationMemberManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.organization.CustomerOrganizationParticipantManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.permission.RequestParticipantPermissionService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class CustomerOrganizationParticipantServiceImpl
implements CustomerOrganizationParticipantService {
    private final FeatureManager featureManager;
    private final CommonErrors commonErrors;
    private final CustomerOrganizationParticipantManager organizationParticipantManager;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final RequestParticipantPermissionService requestParticipantPermissionService;
    private final CustomerOrganizationMemberManager customerOrganizationMemberManager;
    private final ErrorResultHelper errorResultHelper;
    private final PermissionManager permissionManager;
    private final OutsiderPermissionChecker outsiderPermissionChecker;
    private final CustomerOrganizationError customerOrganizationError;

    @Autowired
    public CustomerOrganizationParticipantServiceImpl(FeatureManager featureManager, CommonErrors commonErrors, CustomerOrganizationParticipantManager organizationParticipantManager, ServiceDeskPermissions serviceDeskPermissions, RequestParticipantPermissionService requestParticipantPermissionService, CustomerOrganizationMemberManager customerOrganizationMemberManager, ErrorResultHelper errorResultHelper, PermissionManager permissionManager, OutsiderPermissionChecker outsiderPermissionChecker, CustomerOrganizationError customerOrganizationError) {
        this.featureManager = featureManager;
        this.commonErrors = commonErrors;
        this.organizationParticipantManager = organizationParticipantManager;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.requestParticipantPermissionService = requestParticipantPermissionService;
        this.customerOrganizationMemberManager = customerOrganizationMemberManager;
        this.errorResultHelper = errorResultHelper;
        this.permissionManager = permissionManager;
        this.outsiderPermissionChecker = outsiderPermissionChecker;
        this.customerOrganizationError = customerOrganizationError;
    }

    public Either<AnError, Collection<CustomerOrganization>> getOrganizationsForIssue(@Nonnull CheckedUser user, @Nonnull Issue issue) {
        return Steps.begin(this.checkFeatureFlagAndViewPermission(user, issue)).then(validated -> this.organizationParticipantManager.getOrganizationsForIssue(issue)).yield((validated, orgs) -> orgs);
    }

    public Either<AnError, Collection<CustomerOrganization>> getOrganizationsForIssueIgnorePermissionCheck(@Nonnull Issue issue) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        return this.organizationParticipantManager.getOrganizationsForIssue(issue);
    }

    public Either<AnError, Collection<CustomerOrganization>> addOrganizationsToIssue(@Nonnull CheckedUser user, @Nonnull Issue issue, @Nonnull Collection<CustomerOrganization> organizations) {
        return Steps.begin(this.checkFeatureFlagAndViewEditPermission(user, issue)).then(success -> this.validateAddOrganizationAgainstCustomerPermission(user, issue, organizations)).then((success, validated) -> this.organizationParticipantManager.addOrganizationsToIssue(user, issue, organizations)).yield((success, validated, addedOrgs) -> addedOrgs);
    }

    public Either<AnError, Collection<CustomerOrganization>> removeOrganizationsFromIssue(@Nonnull CheckedUser user, @Nonnull Issue issue, @Nonnull Collection<CustomerOrganization> organizationsToBeRemoved) {
        return Steps.begin(this.checkFeatureFlagAndViewEditPermission(user, issue)).then(validated -> this.organizationParticipantManager.removeOrganizationsFromIssue(user, issue, organizationsToBeRemoved)).yield((validated, result) -> result);
    }

    public Either<AnError, Unit> validateOrganizationsFieldIssueCreationParams(CheckedUser executingUser, Option<CheckedUser> reporter, Project project, Map<String, String[]> issueParams) {
        if (!this.serviceDeskPermissions.canCreateRequest((SDUser)executingUser, project)) {
            return Either.left((Object)this.commonErrors.NO_PERMISSION_TO_CREATE_REQUEST());
        }
        if (reporter.isDefined()) {
            if (this.serviceDeskPermissions.canViewAgentView((SDUser)executingUser, project) && this.serviceDeskPermissions.canModifyReporter((SDUser)executingUser, project)) {
                return this.organizationParticipantManager.validateOrganizationsFieldIssueCreationParams((CheckedUser)reporter.get(), project, issueParams);
            }
            return Either.left((Object)this.commonErrors.AGENT_PERMISSIONS_ERROR());
        }
        return this.organizationParticipantManager.validateOrganizationsFieldIssueCreationParams(executingUser, project, issueParams);
    }

    private Either<AnError, JSDSuccess> checkFeatureFlagAndViewPermission(CheckedUser user, Issue issue) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        if (!this.serviceDeskPermissions.canViewRequestInPortal((SDUser)user, issue)) {
            return Either.left((Object)this.commonErrors.NO_PERMISSION_TO_VIEW_REQUEST());
        }
        return Either.right((Object)((Object)JSDSuccess.success()));
    }

    private Either<AnError, JSDSuccess> checkFeatureFlagAndViewEditPermission(CheckedUser user, Issue issue) {
        return this.checkFeatureFlagAndViewPermission(user, issue).flatMap(success -> {
            if (!this.hasEditPermission(user, issue) || this.outsiderPermissionChecker.isUserAnOutsider(user, issue)) {
                return Either.left((Object)this.customerOrganizationError.NO_EDIT_PERMISSION_ORGANIZATION());
            }
            return Either.right((Object)((Object)JSDSuccess.success()));
        });
    }

    private Either<AnError, Collection<CustomerOrganization>> validateAddOrganizationAgainstCustomerPermission(CheckedUser user, Issue issue, Collection<CustomerOrganization> addedOrganizations) {
        if (this.requestParticipantPermissionService.canAddAnyParticipant(user, issue)) {
            return Either.right(addedOrganizations);
        }
        Collection<CustomerOrganization> organizationsUserDoesNotBelongTo = this.customerOrganizationMemberManager.filterOrganizationsUserDoesNotBelongTo(user, issue.getProjectObject(), addedOrganizations);
        if (organizationsUserDoesNotBelongTo.isEmpty()) {
            return Either.right(addedOrganizations);
        }
        return Either.left((Object)this.USER_DOES_NOT_BELONG_TO_ORGANISATIONS_ERROR(organizationsUserDoesNotBelongTo));
    }

    private AnError USER_DOES_NOT_BELONG_TO_ORGANISATIONS_ERROR(Collection<CustomerOrganization> organizations) {
        Set organizationNames = organizations.stream().map(CustomerOrganization::getName).collect(Collectors.toSet());
        return this.errorResultHelper.badRequest400("sd.customer.organisation.error.user.not.belong.to", new Object[]{StringUtils.join(organizationNames, (String)", ")}).build();
    }

    private boolean hasEditPermission(CheckedUser user, Issue issue) {
        return this.permissionManager.hasPermission(ProjectPermissions.EDIT_ISSUES, issue, user.forJIRA());
    }
}

