/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.reqparticipants.organization;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.customfields.organization.CustomerOrganizationsCFManager;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationManager;
import com.atlassian.servicedesk.internal.feature.organization.error.CustomerOrganizationError;
import com.atlassian.servicedesk.internal.feature.organization.member.CustomerOrganizationMemberManager;
import com.atlassian.servicedesk.internal.feature.organization.util.CustomerOrganizationUtil;
import com.atlassian.servicedesk.internal.feature.reqparticipants.organization.CustomerOrganizationParticipantManager;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerOrganizationParticipantManagerImpl
implements CustomerOrganizationParticipantManager {
    private final CustomerOrganizationsCFManager customerOrganizationsCFManager;
    private final ServiceDeskInternalManager serviceDeskManager;
    private final CustomerOrganizationManager organisationManager;
    private final CustomerOrganizationMemberManager organisationMemberManager;
    private final UserFactory userFactory;
    private final CommonErrors commonErrors;
    private final CustomerOrganizationError organisationError;

    @Autowired
    public CustomerOrganizationParticipantManagerImpl(CustomerOrganizationsCFManager customerOrganizationsCFManager, ServiceDeskInternalManager serviceDeskManager, CustomerOrganizationManager organisationManager, CustomerOrganizationMemberManager organisationMemberManager, UserFactory userFactory, CommonErrors commonErrors, CustomerOrganizationError organisationError) {
        this.customerOrganizationsCFManager = customerOrganizationsCFManager;
        this.serviceDeskManager = serviceDeskManager;
        this.organisationManager = organisationManager;
        this.organisationMemberManager = organisationMemberManager;
        this.userFactory = userFactory;
        this.commonErrors = commonErrors;
        this.organisationError = organisationError;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Collection<CustomerOrganization>> getOrganizationsForIssue(@Nonnull Issue issue) {
        Objects.requireNonNull(issue);
        if (!this.serviceDeskManager.isServiceDeskEnabled(issue.getProjectObject())) {
            return io.atlassian.fugue.Either.left((Object)this.commonErrors.NOT_A_SERVICEDESK_PROJECT());
        }
        io.atlassian.fugue.Either<AnError, Set<CustomerOrganization>> organisationsEither = this.customerOrganizationsCFManager.getOrganizationsFromIssue(issue);
        if (organisationsEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)organisationsEither.left().get());
        }
        return this.filterProjectOrganisations(issue.getProjectObject(), (Collection)organisationsEither.right().get());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Collection<CheckedUser>> getOrganizationMembersForIssue(@Nonnull Issue issue) {
        return this.getOrganizationsForIssue(issue).map(orgs -> orgs.stream().map(CustomerOrganization::getName).collect(Collectors.toSet())).map(this.organisationMemberManager::getUserKeysInOrganizations).map(this::toCheckedUser);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Collection<CustomerOrganization>> addOrganizationsToIssue(@Nonnull CheckedUser user, @Nonnull Issue issue, @Nonnull Collection<CustomerOrganization> organizations) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(issue, "issue");
        Objects.requireNonNull(organizations, "organisations");
        Project project = issue.getProjectObject();
        if (!this.serviceDeskManager.isServiceDeskEnabled(issue.getProjectObject())) {
            return io.atlassian.fugue.Either.left((Object)this.commonErrors.NOT_A_SERVICEDESK_PROJECT());
        }
        return Steps.begin(this.filterProjectOrganisations(project, organizations)).then(validOrganisations -> this.checkInvalidAddedOrganisations((Collection<CustomerOrganization>)validOrganisations, organizations)).then((validOrganisations, validAddedOrganisations) -> this.combineWithExistingOrganisations(issue, (Collection<CustomerOrganization>)validAddedOrganisations)).then((validOrganisations, validAddedOrganisations, updatedOrganisations) -> this.customerOrganizationsCFManager.updateField(user, (Set<CustomerOrganization>)updatedOrganisations, issue)).yield((validOrganisations, validAddedOrganisations, updatedOrganisations, success) -> validAddedOrganisations);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Collection<CustomerOrganization>> removeOrganizationsFromIssue(@Nonnull CheckedUser user, @Nonnull Issue issue, @Nonnull Collection<CustomerOrganization> organizations) {
        if (!this.serviceDeskManager.isServiceDeskEnabled(issue.getProjectObject())) {
            return io.atlassian.fugue.Either.left((Object)this.commonErrors.NOT_A_SERVICEDESK_PROJECT());
        }
        return Steps.begin(this.customerOrganizationsCFManager.getOrganizationsFromIssue(issue)).then(existingOrganisations -> this.filterOrgsToBeRemovedWithExistingOrgs((Collection<CustomerOrganization>)existingOrganisations, organizations)).then((existingOrganisations, filteredOrganisations) -> this.removeOrganisationsFromIssue(user, issue, (Collection<CustomerOrganization>)existingOrganisations, (Collection<CustomerOrganization>)filteredOrganisations)).yield((existingOrganisations, filteredOrganisations, result) -> filteredOrganisations);
    }

    @Override
    public boolean isMemberOfAnyOrganizationsInIssue(CheckedUser user, Issue issue) {
        Set<Integer> organisations = CustomerOrganizationUtil.transformToIds((Collection)this.customerOrganizationsCFManager.getOrganizationsFromIssue(issue).getOrElse(Collections.emptySet()));
        return this.organisationMemberManager.isMemberOfAnyOrganizationsInProject(organisations, user, issue.getProjectObject());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Unit> validateOrganizationsFieldIssueCreationParams(CheckedUser user, Project project, Map<String, String[]> issueParams) {
        io.atlassian.fugue.Either<AnError, Collection<CustomerOrganization>> orgIssueParams = this.getOrganisationsFromIssueParams(issueParams);
        if (orgIssueParams.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)orgIssueParams.left().get());
        }
        Collection organisationsToShare = (Collection)orgIssueParams.right().get();
        if (organisationsToShare.isEmpty()) {
            return io.atlassian.fugue.Either.right((Object)Unit.VALUE);
        }
        return Steps.begin(this.organisationMemberManager.getUserOrganizationsInProject(user, project)).then(validOrganisations -> this.filterSharedOrganisationsWithUserOrganisations((Collection<CustomerOrganization>)validOrganisations, organisationsToShare)).yield((validOrganisations, toBeAdded) -> Unit.VALUE);
    }

    private io.atlassian.fugue.Either<AnError, JSDSuccess> removeOrganisationsFromIssue(CheckedUser user, Issue issue, Collection<CustomerOrganization> existingOrganisations, Collection<CustomerOrganization> organisationsToBeRemoved) {
        if (organisationsToBeRemoved.isEmpty()) {
            return io.atlassian.fugue.Either.right((Object)((Object)JSDSuccess.success()));
        }
        HashSet<CustomerOrganization> updatedOrganisations = new HashSet<CustomerOrganization>(existingOrganisations);
        updatedOrganisations.removeAll(organisationsToBeRemoved);
        return this.customerOrganizationsCFManager.updateField(user, updatedOrganisations, issue);
    }

    private io.atlassian.fugue.Either<AnError, Collection<CustomerOrganization>> filterOrgsToBeRemovedWithExistingOrgs(Collection<CustomerOrganization> existingOrganisations, Collection<CustomerOrganization> organisationsToBeRemoved) {
        return io.atlassian.fugue.Either.right((Object)CollectionUtils.intersection(organisationsToBeRemoved, existingOrganisations));
    }

    private io.atlassian.fugue.Either<AnError, Set<CustomerOrganization>> combineWithExistingOrganisations(Issue issue, Collection<CustomerOrganization> validOrganisations) {
        io.atlassian.fugue.Either<AnError, Set<CustomerOrganization>> existingOrgs = this.customerOrganizationsCFManager.getOrganizationsFromIssue(issue);
        return existingOrgs.map(orgs -> {
            orgs.addAll(validOrganisations);
            return orgs;
        });
    }

    private io.atlassian.fugue.Either<AnError, Collection<CustomerOrganization>> checkInvalidAddedOrganisations(Collection<CustomerOrganization> validOrganisations, Collection<CustomerOrganization> addedOrganisations) {
        Collection invalidAddedOrganisations = CollectionUtils.subtract(addedOrganisations, validOrganisations);
        if (invalidAddedOrganisations.isEmpty()) {
            return io.atlassian.fugue.Either.right(addedOrganisations);
        }
        return io.atlassian.fugue.Either.left((Object)this.organisationError.ORGANISATIONS_NOT_ASSOCIATED_WITH_PROJECT(invalidAddedOrganisations));
    }

    private io.atlassian.fugue.Either<AnError, Collection<CustomerOrganization>> filterSharedOrganisationsWithUserOrganisations(Collection<CustomerOrganization> userOrganisations, Collection<CustomerOrganization> sharedOrganisations) {
        Collection invalidOrgs = CollectionUtils.subtract(sharedOrganisations, userOrganisations);
        if (invalidOrgs.isEmpty()) {
            return io.atlassian.fugue.Either.right(sharedOrganisations);
        }
        return io.atlassian.fugue.Either.left((Object)this.organisationError.USER_DOES_NOT_BELONG_TO_ORGANISATIONS_ERROR(invalidOrgs));
    }

    private io.atlassian.fugue.Either<AnError, Collection<CustomerOrganization>> filterProjectOrganisations(Project project, Collection<CustomerOrganization> organisations) {
        io.atlassian.fugue.Either<AnError, Collection<CustomerOrganization>> organisationsEither = this.organisationManager.getOrganizationsForProject(project);
        if (organisationsEither.isLeft()) {
            return organisationsEither;
        }
        HashSet organisationSet = new HashSet((Collection)organisationsEither.right().get());
        return io.atlassian.fugue.Either.right(organisations.stream().filter(organisationSet::contains).collect(Collectors.toList()));
    }

    private List<CheckedUser> toCheckedUser(Collection<String> userKeys) {
        return userKeys.stream().map(arg_0 -> ((UserFactory)this.userFactory).wrapUserKey(arg_0)).filter(Either::isRight).map(wrappedUser -> (CheckedUser)wrappedUser.right().get()).collect(Collectors.toList());
    }

    private io.atlassian.fugue.Either<AnError, Collection<CustomerOrganization>> getOrganisationsFromIssueParams(Map<String, String[]> issueParams) {
        Option<CustomField> organisationCF = this.customerOrganizationsCFManager.getOrCreateOrganizationsCF();
        if (organisationCF.isEmpty()) {
            return io.atlassian.fugue.Either.right(Collections.emptyList());
        }
        ArrayList<Object> organisationIdsAsString = new ArrayList<Object>(Arrays.asList((Object[])issueParams.getOrDefault(((CustomField)organisationCF.get()).getId(), new String[0])));
        if (organisationIdsAsString.isEmpty()) {
            return io.atlassian.fugue.Either.right(Collections.emptyList());
        }
        try {
            Set<Integer> organisationIds = organisationIdsAsString.stream().filter(StringUtils::isNotEmpty).map(Integer::parseInt).collect(Collectors.toSet());
            return io.atlassian.fugue.Either.right(this.organisationManager.getOrganizationsById(organisationIds));
        }
        catch (NumberFormatException e) {
            return io.atlassian.fugue.Either.left((Object)this.organisationError.INVALID_ORGANISATION_ID());
        }
    }
}

